% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-boundary.R
\name{get_boundary}
\alias{get_boundary}
\title{Get boundary boxes from Atlantis box information.}
\usage{
get_boundary(boxinfo)
}
\arguments{
\item{boxinfo}{A \code{list} as returned from \code{\link{load_box}}.}
}
\value{
A \code{vector} specifying which boxes are on the boundary.
}
\description{
Use the output from \code{\link{load_box}} and obtain a \code{vector}
specifying which boxes are along the boundary.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
boxes <- load_box(bgm = file.path(d, "VMPA_setas.bgm"))
get_boundary(boxinfo = boxes)
}
\seealso{
\code{\link{load_box}}

Other get functions: \code{\link{get_colpal}},
  \code{\link{get_conv_mgnbiot}}, \code{\link{get_groups}}

Other get functions: \code{\link{get_colpal}},
  \code{\link{get_conv_mgnbiot}}, \code{\link{get_groups}}
}
\author{
Kelli Faye Johnson
}
