% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prm-to-df.R
\name{prm_to_df}
\alias{prm_to_df}
\alias{prm_to_df_ages}
\title{Extract parameters from the biological parameter file and transform them to a dataframe.}
\usage{
prm_to_df(prm_biol, fgs, group, parameter)

prm_to_df_ages(prm_biol, fgs, group, parameter)
}
\arguments{
\item{prm_biol}{Character string giving the connection to the biological parameterfile.
The filename usually contains \code{biol_fishing} and does end in \code{.prm}.}

\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}

\item{group}{Character vector giving the functional Groups to extract.}

\item{parameter}{Character vector giving the parameters to extract.}
}
\value{
Dataframe with columns 'species' and as many columns as parameters.
}
\description{
Extract parameters from the biological parameter file and transform them to a dataframe.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")
group <- c("FPS", "FVS")
parameter <- c("mum", "C")

prm_to_df_ages(prm_biol, fgs, group, parameter)
prm_to_df(prm_biol, fgs, group, parameter)
}
