% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_to_description}
\alias{att_to_description}
\title{Add packages to description}
\usage{
att_to_description(path = ".", path.n = "NAMESPACE",
  path.d = "DESCRIPTION", dir.r = "R", dir.v = "vignettes",
  dir.t = "tests", extra.suggests = NULL, pkg_ignore = NULL,
  document = TRUE)
}
\arguments{
\item{path}{path to the root of the package directory. Default to current directory.}

\item{path.n}{path to namespace file.}

\item{path.d}{path to description file.}

\item{dir.r}{path to directory with R scripts.}

\item{dir.v}{path to vignettes directory. Set to empty (dir.v = "") to ignore.}

\item{dir.t}{path to tests directory. Set to empty (dir.t = "") to ignore.}

\item{extra.suggests}{vector of other packages that should be added in Suggests (pkgdown, covr for instance)}

\item{pkg_ignore}{vector of packages names to ignore.}

\item{document}{Run function document of devtools package}
}
\description{
Add packages to description
}
\examples{
tmpdir <- tempdir()
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_to_description(path = dummypackage)
}
