% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRROC.R
\name{plotRROC}
\alias{plotRROC}
\title{Regression Receiver Operating Characteristic (RROC)}
\usage{
plotRROC(object, ...)
}
\arguments{
\item{object}{An object of class modelAudit or modelResiduals.}

\item{...}{Other modelAudit or model Residuals objects to be plotted together.}
}
\value{
ggplot object
}
\description{
The basic idea of the ROC curves for regression is to show model asymmetry.
The RROC is a plot where on the x-axis we depict total over-estimation and on the y-axis total
under-estimation.
}
\details{
For RROC curves we use a shift, which is an equivalent to the threshold for ROC curves.
For each observation we calculate new prediction: \eqn{\hat{y}'=\hat{y}+s} where s is the shift.
Therefore, there are different error values for each shift: \eqn{e_i = \hat{y_i}' - y_i}

Over-estimation is calculated as: \eqn{OVER= \sum(e_i|e_i>0)}.

Under-estimation is calculated as: \eqn{UNDER = \sum(e_i|e_i<0)}.

 The shift equals 0 is represented by a dot.

 The Area Over the RROC Curve (AOC) equals to the variance of the errors multiplied by \eqn{frac{n^2}{2}}.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotRROC(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotRROC(lm_au, rf_au)

}
\references{
Hernández-Orallo, José. 2013. ‘ROC Curves for Regression’. Pattern Recognition 46 (12): 3395–3411.
}
\seealso{
\code{\link{plot.modelAudit}, \link{plotROC}, \link{plotREC}}
}
