% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPrediction.R
\name{plotPrediction}
\alias{plotPrediction}
\title{Predicted response vs Observed or Variable Values}
\usage{
plotPrediction(object, ..., variable = NULL, smooth = FALSE,
  abline = TRUE, split = "none")
}
\arguments{
\item{object}{An object of class modelAudit or modelResiduals.}

\item{...}{Other modelAudit or modelResiduals objects to be plotted together.}

\item{variable}{Only for modelAudit objects. Name of model variable to order residuals. If value is NULL data order is taken. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}

\item{smooth}{Logical, indicates whenever smooth line should be added.}

\item{abline}{Logical, indicates whenever function y=x shoulbe added.}

\item{split}{Character. If "model" plot will be splitted by model.}
}
\description{
Plot of predicted response vs observed or variable Values.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotPrediction(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotPrediction(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
