% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rec.R
\name{plot_rec}
\alias{plot_rec}
\alias{plotREC}
\title{Regression Error Characteristic Curves (REC)}
\usage{
plot_rec(object, ...)

plotREC(object, ...)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}
}
\value{
A ggplot object.
}
\description{
Error Characteristic curves are a generalization of ROC curves.
On the x axis of the plot there is an error tolerance and on the y axis there is a percentage
of observations predicted within the given tolerance.
}
\details{
REC curve estimates the Cumulative Distribution Function (CDF) of the error

Area Over the REC Curve (REC) is a biased estimate of the expected error
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)
plot_rec(mr_lm)
plot(mr_lm, type = "rec")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)
plot_rec(mr_lm, mr_rf)
plot(mr_lm, mr_rf, type = "rec")


}
\references{
Bi J., Bennett K.P. (2003). Regression error characteristic curves, in: Twentieth
International Conference on Machine Learning (ICML-2003), Washington, DC.
}
\seealso{
\code{\link{plot_roc}, \link{plot_rroc}}
}
