% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_rmse.R
\name{score_rmse}
\alias{score_rmse}
\alias{scoreRMSE}
\title{Root Mean Square Error}
\usage{
score_rmse(object, data = NULL, ...)

scoreRMSE(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calcuate the score. Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
Root Mean Square Error.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
score_rmse(exp_lm)


}
\seealso{
\code{\link{score}}
}
