% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_auditor}
\alias{plot_auditor}
\alias{plot.auditor_model_residual}
\alias{plot.auditor_model_performance}
\alias{plot.auditor_model_halfnormal}
\alias{plot.auditor_model_evaluation}
\alias{plot.auditor_model_cooksdistance}
\title{Model Diagnostic Plots}
\usage{
plot_auditor(x, ..., type = "residual", ask = TRUE, grid = TRUE)

\method{plot}{auditor_model_residual}(x, ..., type = "residual", ask = TRUE, grid = TRUE)

\method{plot}{auditor_model_performance}(x, ..., type = "residual", ask = TRUE, grid = TRUE)

\method{plot}{auditor_model_halfnormal}(x, ..., type = "residual", ask = TRUE, grid = TRUE)

\method{plot}{auditor_model_evaluation}(x, ..., type = "residual", ask = TRUE, grid = TRUE)

\method{plot}{auditor_model_cooksdistance}(x, ..., type = "residual", ask = TRUE, grid = TRUE)
}
\arguments{
\item{x}{object of class \code{auditor_model_residual} (created with \code{\link{model_residual}} function),
\code{auditor_model_performance} (created with \code{\link{model_performance}} function),
\code{auditor_model_evaluation} (created with \code{\link{model_evaluation}} function),
\code{auditor_model_cooksdistance} (created with \code{\link{model_cooksdistance}} function),
or \code{auditor_model_halfnormal} (created with \code{\link{model_halfnormal}} function).}

\item{...}{other arguments dependent on the type of plot or additional objects of classes \code{'auditor_model_residual',
'auditor_model_performance', 'auditor_model_evaluation', 'auditor_model_cooksdistance', 'auditor_model_halfnormal'}.}

\item{type}{the type of plot. Character or vector of characters. Possible values: \code{'acf', 'autocorrelation', 'cooksdistance', 'halfnormal',
'lift', 'pca', 'radar', 'correlation', 'prediction', 'rec', 'resiual', 'residual_boxplot','residual_density',
'roc', 'rroc', 'scalelocation', 'tsecdf'} (for detailed description see corresponding functions in see also section).}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot, see \code{\link[graphics]{par}(ask=)}.}

\item{grid}{logical; if \code{TRUE} plots will be plotted on the grid.}
}
\value{
A ggplot object.
}
\description{
This function provides several diagnostic plots for regression and classification models.
Provide object created with one of auditor's computational functions, \code{\link{model_residual}},
\code{\link{model_cooksdistance}}, \code{\link{model_evaluation}}, \code{\link{model_performance}},
\code{\link{model_evaluation}}.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plot(mr_lm)
plot(mr_lm, type = "prediction")

hn_lm <- model_halfnormal(lm_audit)
plot(hn_lm)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)

mp_rf <- model_performance(rf_audit)
mp_lm <- model_performance(lm_audit)
plot(mp_lm, mp_rf)

}
\seealso{
\code{\link{plot_acf}, \link{plot_autocorrelation}, \link{plot_cooksdistance},
\link{plot_halfnormal}, \link{plot_residual_boxplot}, \link{plot_lift}, \link{plot_pca},
\link{plot_radar}, \link{plot_correlation},
\link{plot_prediction}, \link{plot_rec}, \link{plot_residual_density}, \link{plot_residual}, \link{plot_roc},
\link{plot_rroc}, \link{plot_scalelocation}, \link{plot_tsecdf}}
}
