% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residual_density.R
\name{plot_residual_density}
\alias{plot_residual_density}
\alias{plotResidualDensity}
\title{Residual Density Plot}
\usage{
plot_residual_density(object, ..., variable = "", show_rugs = TRUE)

plotResidualDensity(object, ..., variable = NULL)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}

\item{variable}{Split plot by variable's factor level or median.
If \code{variable="_y_"}, the plot will be split by actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the plot will be split by predicted response.
If \code{variable = NULL}, the plot will be split by observation index
If \code{variable = ""} plot is not split (default option).}

\item{show_rugs}{Adds rugs layer to the plot. By default it's TRUE}
}
\value{
A ggplot object.
}
\description{
Density of model residuals.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plot_residual_density(mr_lm)
plot(mr_lm, type = "residual_density")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plot_residual_density(mr_lm, mr_rf)
plot(mr_lm, mr_rf, type = "residual_density")

}
\seealso{
\code{\link{plot_residual}}
}
