% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReg.R
\name{autoReg_sub}
\alias{autoReg_sub}
\title{Perform univariable and multivariable regression and stepwise backward regression automatically}
\usage{
autoReg_sub(
  fit,
  threshold = 0.2,
  uni = FALSE,
  multi = TRUE,
  final = FALSE,
  imputed = FALSE,
  keepstats = FALSE,
  showstats = TRUE,
  ...
)
}
\arguments{
\item{fit}{An object of class lm or glm}

\item{threshold}{numeric}

\item{uni}{logical whether or not perform univariate regression}

\item{multi}{logical whether or not perform multivariate regression}

\item{final}{logical whether or not perform stepwise backward elimination}

\item{imputed}{logical whether or not include imputed model}

\item{keepstats}{logical whether or not keep statistics}

\item{showstats}{logical whether or not show descriptive statistics}

\item{...}{Further arguments to be passed to imputedReg()}
}
\value{
An object of class "autoReg" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
\item{attr(*,"model")}{name of model. One of "lm","glm" or "coxph"}
}
}
\description{
Perform univariable and multivariable regression and stepwise backward regression automatically
}
