% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFitSummary.R
\name{addFitSummary}
\alias{addFitSummary}
\title{Add model summary to an object of class gaze}
\usage{
addFitSummary(df, fit, statsname = "")
}
\arguments{
\item{df}{An object of class "gaze" or "autoReg"}

\item{fit}{An object of class "glm" or "lm" or "crr"}

\item{statsname}{character Name of statistics}
}
\value{
addFitSummary returns an object of \code{\link{gaze}} or \code{\link{autoReg}} - the same class as df
}
\description{
Add model summary to an object of class gaze
}
\examples{
require(survival)
require(dplyr)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~rx+age+sex+nodes+obstruct+perfor,data=colon)
df=autoReg(fit,uni=FALSE)
final=fit2final(fit)
df \%>\% addFitSummary(final,statsname="HR (final)") \%>\% myft()
}
