% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plines.R
\name{plines}
\alias{plines}
\title{Projected lines function}
\usage{
plines(x, y = NULL, type = "l", proj, ...)
}
\arguments{
\item{x}{coordinate vectors of points to join.}

\item{y}{coordinate vectors of points to join.}

\item{type}{character indicating the type of plotting; actually any of
    the \code{type}s as in \code{\link{plot.default}}.}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{Further graphical parameters (see \code{\link{par}}) may
    also be supplied as arguments, particularly, line type, \code{lty},
    line width, \code{lwd}, color, \code{col} and for \code{type = "b"},
    \code{pch}.  Also the line characteristics \code{lend}, \code{ljoin}
    and \code{lmitre}.}
}
\description{
\code{plines} takes coordinates and joins the corresponding points
with line segments, possibly after projection.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for
projection.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(grid = FALSE))
# get national boundaries
data(worldMapEnv, package = "maps")
worldpoly <- maps::map("world", plot = FALSE)
# add boundaries to existing plot
plines(worldpoly, proj = "bonne")
}
\seealso{
\code{\link[autoimage]{pimage}},
  \code{\link[mapproj]{mapproject}}, \code{\link[graphics]{lines}}
}
