% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_start.R
\name{log_start}
\alias{log_start}
\title{Start the log thread.}
\usage{
log_start(
  path,
  seconds = 1,
  pids = c(local = Sys.getpid()),
  error = getOption("autometric_error", TRUE)
)
}
\arguments{
\item{path}{Character string, path to a file to log resource usage.
On Windows, the path must point to a physical file on disk.
On Unix-like systems, \code{path} can be \code{"/dev/stdout"} to print to
standard output or \code{"/dev/stderr"} to print to standard error.

Standard output is the most convenient option for high-performance
computing scenarios where worker processes already write to log files.
Such workers usually already redirect standard output to a
physical file, as with a cluster like SLURM,
or capture messages with
\href{https://aws.amazon.com/cloudwatch/}{Amazon CloudWatch}.

Normally, standard output and standard error are discouraged because
of how they interact with the R API and R console. However, the
exported user interface of \code{autometric} only ever
prints from a detached POSIX thread where it is unsafe to
use \code{Rprintf()} or \code{REprintf()}.}

\item{seconds}{Positive number, number of seconds between writes to the
log file. This number should be noticeably large, anywhere between
half a second to several seconds or minutes.
A low number of seconds could burden the operating system
and generate large log files. Because of the way CPU usage measurements
work, the first log entry starts only after after the first interval of
\code{seconds} has passed.}

\item{pids}{Nonempty vector of non-negative integers
of process IDs to monitor. NOTE: On Mac OS, only the currently running
process can be monitored.
This is due to security restrictions around certain system calls, c.f.
\url{https://os-tres.net/blog/2010/02/17/mac-os-x-and-task-for-pid-mach-call/}. # nolint
If the \code{pids} vector is named, then the names will show alongside the
process IDs in the log entries.}

\item{error}{\code{TRUE} to throw an error if the thread is not supported on
the current platform. (See \code{\link[=log_support]{log_support()}}.)}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Start a background thread that periodically writes
system usage metrics of the current R process to a log file.
See \code{\link[=log_read]{log_read()}} for explanations of the specific metrics.
}
\details{
Only one thread can run at a time. If the thread is already
running, then \code{\link[=log_start]{log_start()}} does not start an additional one.
Before creating a new thread, call \code{\link[=log_stop]{log_stop()}} to terminate
the first one.
}
\examples{
  path <- tempfile()
  log_start(seconds = 0.5, path = path)
  Sys.sleep(2)
  log_stop()
  Sys.sleep(2)
  log_read(path)
  unlink(path)
}
