% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_vs_slide.R
\name{g_vs_slide}
\alias{g_vs_slide}
\title{Plot mean values of VS}
\usage{
g_vs_slide(
  adsl,
  advs,
  arm = "TRT01P",
  paramcd = "PARAM",
  subtitle = "Plot of Mean and 95\% Confidence Limits by Visit.",
  ...
)
}
\arguments{
\item{adsl}{ADSL data}

\item{advs}{ADVS data}

\item{arm}{`"TRT01P"` by default}

\item{paramcd}{Which variable to use for plotting. By default `"PARAM"`}

\item{subtitle}{character scalar forwarded to g_lineplot}

\item{...}{|
Gets forwarded to `tern::g_lineplot()`.
This lets you specify additional arguments to `tern::g_lineplot()`}
}
\description{
Wrapper for `g_mean_general()`.
Requires filtering of the datasets (e.g. using SUFFIX in spec.yml)
}
\examples{
\dontshow{if (require('rsvg')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
advs_filtered <- eg_advs \%>\% filter(
PARAMCD == "SYSBP"
)
plot_vs <- g_vs_slide(
adsl = eg_adsl,
advs = advs_filtered,
paramcd = "PARAM",
subtitle_add_unit = FALSE
) +
ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 45, hjust = 1))
# makes editable plots
generate_slides(plot_vs, paste0(tempdir(), "/g_vs.pptx"), fig_editable = TRUE)
# not editable plots, which appear as images
generate_slides(plot_vs, paste0(tempdir(), "/g_vs.pptx"), fig_editable = FALSE)
\dontshow{\}) # examplesIf}
}
\author{
Stefan Thoma (`thomas7`)
}
