% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_fixed_pars.R
\name{stsm_fixed_pars}
\alias{stsm_fixed_pars}
\title{Fixed parameter setting}
\usage{
stsm_fixed_pars(
  par,
  y,
  det_obs = FALSE,
  det_trend = FALSE,
  det_drift = FALSE,
  det_cycle = FALSE,
  det_seas = FALSE,
  saturating_growth = FALSE
)
}
\arguments{
\item{par}{Initial parameters}

\item{y}{Vector of univariate time series}

\item{det_obs}{Set the observation equation error variance to 0 (deterministic observation equation)
If det_obs = TRUE then the error variance of the observation equation (sig_e) is set to 0}

\item{det_trend}{Set the trend error variance to 0 (deterministic trend)
If det_trend = TRUE then the error variance of the trend equation (sig_t) is set to 0 and 
is referred to as a smooth trend}

\item{det_drift}{Set the drift error variance to 0 (deterministic drift)
If det_drift = TRUE then the error variance of the drift equation (sig_d) is set to 0 and 
is refereed to as a deterministic drift}

\item{det_cycle}{Set the cycle error variance to 0 (deterministic cycle)
If det_cycle = TRUE then the error variance of the cycle equation (sig_c) is set to 0 and 
is referred to as a deterministic cycle}

\item{det_seas}{Set the seasonality error variances to 0 (deterministic seasonality)
If det_seas = TRUE then the error variance all seasonality frequency j equations (sig_s) 
are set to 0 and is referred to as deterministic seasonality}

\item{saturating_growth}{Force the growth rate to converge to 0 in the long term}
}
\description{
Fixed parameter setting
}
