% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_assign_ipv6_addresses}
\alias{ec2_assign_ipv6_addresses}
\title{Assign Ipv6 Addresses}
\usage{
ec2_assign_ipv6_addresses(
  NetworkInterfaceId,
  Ipv6AddressCount = NULL,
  Ipv6Addresses = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The ID of the network interface.}

\item{Ipv6AddressCount}{Integer. The number of additional IPv6 addresses to assign to the network interface.[optional]}

\item{Ipv6Addresses}{List. One or more specific IPv6 addresses to be assigned to the network interface.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Assign Ipv6 Addresses
}
\section{NetworkInterfaceId}{

The ID of the network
interface.
}

\section{Ipv6AddressCount}{

The number of additional IPv6 addresses
to assign to the network interface. The specified number of IPv6
addresses are assigned in addition to the existing IPv6 addresses that
are already assigned to the network interface. Amazon EC2 automatically
selects the IPv6 addresses from the subnet range. You can\'t use this
option if specifying specific IPv6 addresses.
}

\section{Ipv6Addresses}{

One or
more specific IPv6 addresses to be assigned to the network interface.
You can\'t use this option if you\'re specifying a number of IPv6
addresses.
}

