% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_network_acl_entry}
\alias{ec2_delete_network_acl_entry}
\title{Delete Network Acl Entry}
\usage{
ec2_delete_network_acl_entry(
  Egress,
  NetworkAclId,
  RuleNumber,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Egress}{Logical. Indicates whether the rule is an egress rule.}

\item{NetworkAclId}{String. The ID of the network ACL.}

\item{RuleNumber}{Integer. The rule number of the entry to delete.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the
specified ingress or egress entry (rule) from the specified network
ACL.
}
\section{Egress}{

Indicates whether the rule
is an egress rule.
}

\section{NetworkAclId}{

The ID of the network
ACL.
}

\section{RuleNumber}{

The rule number of the entry to
delete.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

