% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_tags}
\alias{ec2_delete_tags}
\title{Delete Tags}
\usage{
ec2_delete_tags(
  ResourceId,
  DryRun = NULL,
  Tag = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ResourceId}{List.   The IDs of the resources, separated by spaces.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Tag}{List.   The tags to delete.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Delete Tags
}
\section{ResourceId}{


The IDs of the resources, separated by spaces.

Constraints: Up to 1000 resource IDs. We recommend breaking up this
request into smaller batches.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Tag}{


The tags to delete. Specify a tag key and an optional tag value to
delete specific tags. If you specify a tag key without a tag value, we
delete any tag with this key regardless of its value. If you specify a
tag key with an empty string as the tag value, we delete the tag only if
its value is an empty string.

If you omit this parameter, we delete all user-defined tags for the
specified resources. We do not delete AWS-generated tags (tags that have
the \verb{aws:} prefix).
}

