% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_client_vpn_route}
\alias{ec2_delete_client_vpn_route}
\title{Delete Client Vpn Route}
\usage{
ec2_delete_client_vpn_route(
  ClientVpnEndpointId,
  DestinationCidrBlock,
  TargetVpcSubnetId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ClientVpnEndpointId}{Character. The ID of the Client VPN endpoint from which the route is to be deleted.}

\item{DestinationCidrBlock}{Character. The IPv4 address range, in CIDR notation, of the route to be deleted.}

\item{TargetVpcSubnetId}{Character. The ID of the target subnet used by the route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Deletes a route from a Client VPN
endpoint. You can only delete routes that you manually added using the
\strong{CreateClientVpnRoute} action. You cannot delete routes that were
automatically added when associating a subnet. To remove routes that
have been automatically added, disassociate the target subnet from the
Client VPN endpoint.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint from which the route is to be deleted.
}

\section{DestinationCidrBlock}{

The
IPv4 address range, in CIDR notation, of the route to be
deleted.
}

\section{TargetVpcSubnetId}{

The ID of the target subnet used by the
route.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

