% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_credentials.R
\name{read_credentials}
\alias{read_credentials}
\alias{use_credentials}
\alias{default_credentials_file}
\title{Use Credentials from .aws/credentials File}
\usage{
read_credentials(file = Sys.getenv("AWS_SHARED_CREDENTIALS_FILE",
  default_credentials_file()))

use_credentials(profile = Sys.getenv("AWS_PROFILE", "default"),
  file = Sys.getenv("AWS_SHARED_CREDENTIALS_FILE",
  default_credentials_file()))

default_credentials_file()
}
\arguments{
\item{file}{A character string containing a path to a \samp{.aws/credentials} file. By default, the standard/centralized file given by \env{AWS_SHARED_CREDENTIALS_FILE} is used, otherwise an assumed default location is assumed. For \code{use_credentials}, this can also be an object of class \dQuote{aws_credentials} (as returned by \code{use_credentials}).}

\item{profile}{A character string specifying which profile to use from the file. By default, the \dQuote{default} profile is used.}
}
\description{
Use a profile from a \samp{.aws/credentials} file
}
\details{
\code{read_credentials} reads and parses a \samp{.aws/credentials} file into an object of class \dQuote{aws_credentials}.

\code{use_credentials} uses credentials from a profile stored in a credentials file to set the environment variables used by this package. It is called by default during package load if the \env{AWS_ACCESS_KEY_ID} and \env{AWS_SECRET_ACCESS_KEY} environment variables are not set.
}
\examples{
\dontrun{
# read and parse a credentials file
read_credentials()

# set environment variables from a profile
use_credentials()
}
}
\references{
\href{https://blogs.aws.amazon.com/security/post/Tx3D6U6WSFGOK2H/A-New-and-Standardized-Way-to-Manage-Credentials-in-the-AWS-SDKs}{Amazon blog post describing the format}
}
\seealso{
\code{\link{signature_v2_auth}}, \code{\link{locate_credentials}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
