% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_calibrated_pvalues}
\alias{get_calibrated_pvalues}
\title{Use the calibration of pvalues in a slow multi-hypothesis setting}
\usage{
get_calibrated_pvalues(calibration, es1)
}
\arguments{
\item{calibration}{Output of function \code{calibrate_test()}}

\item{es1}{Max Enrichment score given by function \code{aziz.test()} $es.
A vector containing the max enrichment scores from many variables is acceptable}
}
\value{
calibrated pvalue(s) corresponding to the max enrichment score(s) given
}
\description{
Compute the pvalues from a single set of permutations obtained from \code{calibrate_test}.
Useful if testing a large number of variables at once since it allows
  running permutations only once behorehand rather than for every variable.
  Used in conjunction with "\code{calibrate_test}"
}
\examples{
y = c(rep(1,200),rep(0,200))
x = rnorm(400)
calibration = calibrate_test(y,rep=100)
es = aziz.test(y,x,rep=0)$es #No need for permutations, pvalues computed from calibration
get_calibrated_pvalues(calibration,es)
}
\seealso{
\code{\link{calibrate_test}}, \code{\link{aziz.test}}
}
