% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperdrive.R
\name{get_best_run_by_primary_metric}
\alias{get_best_run_by_primary_metric}
\title{Return the best performing run amongst all completed runs}
\usage{
get_best_run_by_primary_metric(hyperdrive_run, include_failed = TRUE,
  include_canceled = TRUE)
}
\arguments{
\item{hyperdrive_run}{The \code{HyperDriveRun} object.}

\item{include_failed}{If \code{TRUE}, include the failed runs.}

\item{include_canceled}{If \code{TRUE}, include the canceled runs.}
}
\value{
The \code{Run} object.
}
\description{
Find and return the run that corresponds to the best performing run
amongst all the completed runs.

The best performing run is identified solely based on the primary metric
parameter specified in the \code{HyperDriveConfig} (\code{primary_metric_name}).
The \code{PrimaryMetricGoal} governs whether the minimum or maximum of the
primary metric is used. To do a more detailed analysis of all the
run metrics launched by this HyperDrive run, use \code{get_child_run_metrics()}.
Only one of the runs is returned from \code{get_best_run_by_primary_metric()},
even if several of the runs launched by this HyperDrive run reached
the same best metric.
}
