% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdsm.R
\name{fdsm.trials}
\alias{fdsm.trials}
\title{Estimate number of Monte Carlo trials needed for FDSM backbone}
\usage{
fdsm.trials(
  B,
  type1 = 0.05,
  type2 = 0.05,
  alpha = 0.05,
  fwer = TRUE,
  signed = FALSE,
  riskyp = 0
)
}
\arguments{
\item{B}{graph: An unweighted bipartite graph object of class matrix, sparse matrix, igraph, edgelist, or network object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}

\item{type1}{numeric: Type-I error used in sample size calculation}

\item{type2}{numeric: Type-II error used in sample size calculation}

\item{alpha}{numeric: Desired Type-I error for tests of edge significance}

\item{fwer}{boolean: If TRUE, \code{alpha} is interpreted as the desired familywise error rate.
If FALSE, \code{alpha} is interpreted as the desired testwise error rate.}

\item{signed}{boolean: TRUE to estimate the number of trials needed to extract a signed backbone, FALSE to estimate
the number of trials needed to extract a binary backbone}

\item{riskyp}{numeric: Expected riskiest edge p-value, as a proportion of \code{alpha} (see details)}
}
\value{
integer: estimated minimum number of Monte Carlo trials
}
\description{
\code{fdsm.trials} estimates the number of Monte Carlo trials needed to extract an FDSM backbone, correcting for
familywise error rate, and given tolerance for Type-I and Type-II errors
}
\details{
This function uses sample size estimation equations 2.22 and 2.24 given by Fleiss et al. (2013).

If \code{fwer = TRUE}, it assumes that a conservative Bonferroni correction will be used to maintain
the familywise error rate across the independent hypothesis tests required for every edge in
the bipartite projection of \code{B}.

The required number of trials depends in part on the difference between an edge's estimated p-value and the
desired level of statistical significance. If an edge is deemed statistically significant when its p-value is
less than 0.05, then there is little risk in making a decision about an edge with an estimated p-value of 0,
and fewer trials are required. In contrast, if the edge's estimated p-value is 0.049, there is more risk of
making an error and more trials are required. The \code{riskyp} parameter specifies how close to \code{alpha} the riskiest
expected edge p-value, as a proportion of \code{alpha}. For example, if \code{alpha = 0.05} and \code{riskyp = 0.75}, then
the expected riskiest p-value is 0.0375.
}
\examples{
B <- matrix(rbinom(100*1000,1,0.5),100,1000)
fdsm.trials(B, riskyp = .75)
}
\references{
{Fleiss, J. L., Levin, B., & Paik, M. C. (2013). Statistical methods for rates and proportions. John Wiley & Sons.}

{Neal, Z. P., Domagalski, R., and Sagan, B. (2021). Comparing Alternatives to the Fixed Degree Sequence Model for Extracting the Backbone of Bipartite Projections. \emph{Scientific Reports}.}
}
