% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{backbone.extract}
\alias{backbone.extract}
\title{Extracts a backbone network from a backbone object}
\usage{
backbone.extract(
  bb.object,
  signed = FALSE,
  alpha = 0.05,
  mtc = "none",
  class = "matrix"
)
}
\arguments{
\item{bb.object}{backbone: backbone S3 class object.}

\item{signed}{Boolean: TRUE for a signed backbone, FALSE for a binary backbone (see details)}

\item{alpha}{Real: significance level of hypothesis test(s)}

\item{mtc}{string: type of Multiple Test Correction to be applied; can be any method allowed by \code{\link{p.adjust}}.}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "sparseMatrix", "igraph", "edgelist"), converted via \link{tomatrix}.}
}
\value{
backbone graph: Binary or signed backbone graph of class given in parameter \code{class}.
}
\description{
\code{backbone.extract} returns a binary or signed adjacency matrix
containing the backbone that retains only the significant edges.
}
\details{
The "backbone" S3 class object is composed of three matrices (the weighted graph, edges' upper-tail p-values,
edges' lower-tail p-values), and a string indicating the null model used to compute p-values.

When \code{signed = FALSE}, a one-tailed test (is the weight stronger) is performed for each edge with a non-zero weight. It
yields a backbone that perserves edges whose weights are significantly \emph{stronger} than expected in the chosen null
model. When \code{signed = TRUE}, a two-tailed test (is the weight stronger or weaker) is performed for each every pair of nodes.
It yields a backbone that contains positive edges for edges whose weights are significantly \emph{stronger}, and
negative edges for edges whose weights are significantly \emph{weaker}, than expected in the chosen null model.
\emph{NOTE: Before v2.0.0, all significance tests were two-tailed and zero-weight edges were evaluated.}
}
\examples{
#A binary bipartite network of 30 agents & 75 artifacts; agents form three communities
B <- rbind(cbind(matrix(rbinom(250,1,.8),10),
                 matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.2),10)),
           cbind(matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.8),10),
                 matrix(rbinom(250,1,.2),10)),
           cbind(matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.8),10)))

backbone.object <- fixedrow(B, alpha = NULL)
bb <- backbone.extract(backbone.object, alpha = 0.05)
}
