% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pb}
\alias{pb}
\title{Poisson binomial distribution function}
\usage{
pb(k, p, lower = TRUE)
}
\arguments{
\item{k}{numeric: values where the pdf should be evaluated}

\item{p}{numeric: vector of success probabilities}

\item{lower}{boolean: If FALSE return lower tail, if FALSE return upper tail}
}
\value{
numeric: probability of observing \code{k} or fewer (if lower = TRUE), or more than \code{k} (if lower = FALSE),
successes when each trial has probability \code{p} of success
}
\description{
\code{pb} computes the poisson binomial distribution function using the refined normal approximation.
}
\details{
The Refined Normal Approximation (RNA) offers a close approximation when \code{length(p)} is large (Hong, 2013). This function
is a slightly more efficient implementation of \code{ppoibin()} from the \code{poibin} package.
}
\examples{
pb(50,runif(100))
}
\references{
{Hong, Y. (2013). On computing the distribution function for the Poisson binomial distribution. \emph{Computational Statistics and Data Analysis, 59}, 41-51. \doi{10.1016/j.csda.2012.10.006}}
}
