% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R
\docType{package}
\name{backbone}
\alias{backbone-package}
\alias{backbone}
\title{backbone: Extracts the Backbone from Graphs}
\description{
Provides methods for extracting an unweighted and sparse subgraph (i.e., a backbone)
that contains only the most "important" edges from:
\itemize{
\item a weighted network using \code{\link[=backbone_from_weighted]{backbone_from_weighted()}}
\item a weighted projection of a bipartite network or hypergraph using \code{\link[=backbone_from_projection]{backbone_from_projection()}}
\item an unweighted network using \code{\link[=backbone_from_unweighted]{backbone_from_unweighted()}}
}

For a detailed illustration of these methods, please see \href{../doc/backbone.html}{the vignette} using \code{vignette("backbone")}.
}
\references{
package: {Neal, Z. P. (2025). backbone: An R Package to Extract Network Backbones. CRAN. \doi{10.32614/CRAN.package.backbone}}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.zacharyneal.com/backbone}
  \item \url{https://github.com/zpneal/backbone}
  \item Report bugs at \url{https://github.com/zpneal/backbone/issues}
}

}
\author{
\strong{Maintainer}: Zachary Neal \email{zpneal@msu.edu} (\href{https://orcid.org/0000-0003-3076-4995}{ORCID})

Other contributors:
\itemize{
  \item Rachel Domagalski [contributor]
  \item Bruce Sagan [contributor]
  \item Karl Godard [contributor]
}

}
