// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_mutau_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_mutau");
    reader.add_event(1, 1, "include", "/functions/prior_increment.stan");
    reader.add_event(1, 0, "start", "/functions/prior_increment.stan");
    reader.add_event(26, 25, "end", "/functions/prior_increment.stan");
    reader.add_event(26, 2, "restart", "model_mutau");
    reader.add_event(139, 113, "end", "model_mutau");
    return reader;
}
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
prior_increment_real(const int& family,
                         const T1__& y,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        local_scalar_t__ inc(DUMMY_VAR__);
        (void) inc;  // dummy to suppress unused var warning
        stan::math::initialize(inc, DUMMY_VAR__);
        stan::math::fill(inc, DUMMY_VAR__);
        current_statement_begin__ = 4;
        if (as_bool(logical_eq(family, 0))) {
            current_statement_begin__ = 5;
            stan::math::assign(inc, uniform_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 6;
        if (as_bool(logical_eq(family, 1))) {
            current_statement_begin__ = 7;
            stan::math::assign(inc, normal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 8;
        if (as_bool(logical_eq(family, 2))) {
            current_statement_begin__ = 9;
            stan::math::assign(inc, cauchy_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 10;
        if (as_bool(logical_eq(family, 3))) {
            current_statement_begin__ = 11;
            stan::math::assign(inc, student_t_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1), get_base1(pars, 3, "pars", 1)));
        }
        current_statement_begin__ = 12;
        return stan::math::promote_scalar<fun_return_scalar_t__>(inc);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct prior_increment_real_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& family,
                         const T1__& y,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) const {
        return prior_increment_real(family, y, pars, pstream__);
    }
};
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
prior_increment_vec(const int& family,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 16;
        local_scalar_t__ inc(DUMMY_VAR__);
        (void) inc;  // dummy to suppress unused var warning
        stan::math::initialize(inc, DUMMY_VAR__);
        stan::math::fill(inc, DUMMY_VAR__);
        current_statement_begin__ = 17;
        if (as_bool(logical_eq(family, 0))) {
            current_statement_begin__ = 18;
            stan::math::assign(inc, uniform_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 19;
        if (as_bool(logical_eq(family, 1))) {
            current_statement_begin__ = 20;
            stan::math::assign(inc, normal_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 21;
        if (as_bool(logical_eq(family, 2))) {
            current_statement_begin__ = 22;
            stan::math::assign(inc, cauchy_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1)));
        }
        current_statement_begin__ = 23;
        if (as_bool(logical_eq(family, 3))) {
            current_statement_begin__ = 24;
            stan::math::assign(inc, student_t_log(y, get_base1(pars, 1, "pars", 1), get_base1(pars, 2, "pars", 1), get_base1(pars, 3, "pars", 1)));
        }
        current_statement_begin__ = 25;
        return stan::math::promote_scalar<fun_return_scalar_t__>(inc);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct prior_increment_vec_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& family,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& pars, std::ostream* pstream__) const {
        return prior_increment_vec(family, y, pars, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_mutau
  : public stan::model::model_base_crtp<model_mutau> {
private:
        int K;
        int P;
        std::vector<std::vector<double> > theta_hat_k;
        std::vector<std::vector<double> > se_theta_k;
        int pooling_type;
        int prior_hypermean_fam;
        vector_d prior_hypermean_mean;
        matrix_d prior_hypermean_scale;
        int prior_hypersd_fam;
        vector_d prior_hypersd_val;
        int prior_hypercor_fam;
        double prior_hypercor_val;
        int K_test;
        std::vector<std::vector<double> > test_theta_hat_k;
        std::vector<std::vector<double> > test_se_theta_k;
        int K_pooled;
public:
    model_mutau(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_mutau(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_mutau_namespace::model_mutau";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 2);
            current_statement_begin__ = 32;
            validate_non_negative_index("theta_hat_k", "P", P);
            validate_non_negative_index("theta_hat_k", "K", K);
            context__.validate_dims("data initialization", "theta_hat_k", "double", context__.to_vec(P,K));
            theta_hat_k = std::vector<std::vector<double> >(P, std::vector<double>(K, double(0)));
            vals_r__ = context__.vals_r("theta_hat_k");
            pos__ = 0;
            size_t theta_hat_k_k_0_max__ = P;
            size_t theta_hat_k_k_1_max__ = K;
            for (size_t k_1__ = 0; k_1__ < theta_hat_k_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_hat_k_k_0_max__; ++k_0__) {
                    theta_hat_k[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 33;
            validate_non_negative_index("se_theta_k", "P", P);
            validate_non_negative_index("se_theta_k", "K", K);
            context__.validate_dims("data initialization", "se_theta_k", "double", context__.to_vec(P,K));
            se_theta_k = std::vector<std::vector<double> >(P, std::vector<double>(K, double(0)));
            vals_r__ = context__.vals_r("se_theta_k");
            pos__ = 0;
            size_t se_theta_k_k_0_max__ = P;
            size_t se_theta_k_k_1_max__ = K;
            for (size_t k_1__ = 0; k_1__ < se_theta_k_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < se_theta_k_k_0_max__; ++k_0__) {
                    se_theta_k[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t se_theta_k_i_0_max__ = P;
            size_t se_theta_k_i_1_max__ = K;
            for (size_t i_0__ = 0; i_0__ < se_theta_k_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < se_theta_k_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "se_theta_k[i_0__][i_1__]", se_theta_k[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "pooling_type", "int", context__.to_vec());
            pooling_type = int(0);
            vals_i__ = context__.vals_i("pooling_type");
            pos__ = 0;
            pooling_type = vals_i__[pos__++];
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "prior_hypermean_fam", "int", context__.to_vec());
            prior_hypermean_fam = int(0);
            vals_i__ = context__.vals_i("prior_hypermean_fam");
            pos__ = 0;
            prior_hypermean_fam = vals_i__[pos__++];
            current_statement_begin__ = 38;
            validate_non_negative_index("prior_hypermean_mean", "P", P);
            context__.validate_dims("data initialization", "prior_hypermean_mean", "vector_d", context__.to_vec(P));
            prior_hypermean_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(P);
            vals_r__ = context__.vals_r("prior_hypermean_mean");
            pos__ = 0;
            size_t prior_hypermean_mean_j_1_max__ = P;
            for (size_t j_1__ = 0; j_1__ < prior_hypermean_mean_j_1_max__; ++j_1__) {
                prior_hypermean_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 39;
            validate_non_negative_index("prior_hypermean_scale", "P", P);
            validate_non_negative_index("prior_hypermean_scale", "P", P);
            context__.validate_dims("data initialization", "prior_hypermean_scale", "matrix_d", context__.to_vec(P,P));
            prior_hypermean_scale = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, P);
            vals_r__ = context__.vals_r("prior_hypermean_scale");
            pos__ = 0;
            size_t prior_hypermean_scale_j_2_max__ = P;
            size_t prior_hypermean_scale_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < prior_hypermean_scale_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prior_hypermean_scale_j_1_max__; ++j_1__) {
                    prior_hypermean_scale(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "prior_hypermean_scale", prior_hypermean_scale, 0);
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "prior_hypersd_fam", "int", context__.to_vec());
            prior_hypersd_fam = int(0);
            vals_i__ = context__.vals_i("prior_hypersd_fam");
            pos__ = 0;
            prior_hypersd_fam = vals_i__[pos__++];
            current_statement_begin__ = 41;
            validate_non_negative_index("prior_hypersd_val", "3", 3);
            context__.validate_dims("data initialization", "prior_hypersd_val", "vector_d", context__.to_vec(3));
            prior_hypersd_val = Eigen::Matrix<double, Eigen::Dynamic, 1>(3);
            vals_r__ = context__.vals_r("prior_hypersd_val");
            pos__ = 0;
            size_t prior_hypersd_val_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < prior_hypersd_val_j_1_max__; ++j_1__) {
                prior_hypersd_val(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "prior_hypercor_fam", "int", context__.to_vec());
            prior_hypercor_fam = int(0);
            vals_i__ = context__.vals_i("prior_hypercor_fam");
            pos__ = 0;
            prior_hypercor_fam = vals_i__[pos__++];
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "prior_hypercor_val", "double", context__.to_vec());
            prior_hypercor_val = double(0);
            vals_r__ = context__.vals_r("prior_hypercor_val");
            pos__ = 0;
            prior_hypercor_val = vals_r__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "K_test", "int", context__.to_vec());
            K_test = int(0);
            vals_i__ = context__.vals_i("K_test");
            pos__ = 0;
            K_test = vals_i__[pos__++];
            check_greater_or_equal(function__, "K_test", K_test, 0);
            current_statement_begin__ = 47;
            validate_non_negative_index("test_theta_hat_k", "P", P);
            validate_non_negative_index("test_theta_hat_k", "K_test", K_test);
            context__.validate_dims("data initialization", "test_theta_hat_k", "double", context__.to_vec(P,K_test));
            test_theta_hat_k = std::vector<std::vector<double> >(P, std::vector<double>(K_test, double(0)));
            vals_r__ = context__.vals_r("test_theta_hat_k");
            pos__ = 0;
            size_t test_theta_hat_k_k_0_max__ = P;
            size_t test_theta_hat_k_k_1_max__ = K_test;
            for (size_t k_1__ = 0; k_1__ < test_theta_hat_k_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < test_theta_hat_k_k_0_max__; ++k_0__) {
                    test_theta_hat_k[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            validate_non_negative_index("test_se_theta_k", "P", P);
            validate_non_negative_index("test_se_theta_k", "K_test", K_test);
            context__.validate_dims("data initialization", "test_se_theta_k", "double", context__.to_vec(P,K_test));
            test_se_theta_k = std::vector<std::vector<double> >(P, std::vector<double>(K_test, double(0)));
            vals_r__ = context__.vals_r("test_se_theta_k");
            pos__ = 0;
            size_t test_se_theta_k_k_0_max__ = P;
            size_t test_se_theta_k_k_1_max__ = K_test;
            for (size_t k_1__ = 0; k_1__ < test_se_theta_k_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < test_se_theta_k_k_0_max__; ++k_0__) {
                    test_se_theta_k[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t test_se_theta_k_i_0_max__ = P;
            size_t test_se_theta_k_i_1_max__ = K_test;
            for (size_t i_0__ = 0; i_0__ < test_se_theta_k_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < test_se_theta_k_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "test_se_theta_k[i_0__][i_1__]", test_se_theta_k[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 53;
            K_pooled = int(0);
            stan::math::fill(K_pooled, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 54;
            if (as_bool(logical_eq(pooling_type, 2))) {
                current_statement_begin__ = 55;
                stan::math::assign(K_pooled, 0);
            }
            current_statement_begin__ = 56;
            if (as_bool(logical_neq(pooling_type, 2))) {
                current_statement_begin__ = 57;
                stan::math::assign(K_pooled, K);
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 61;
            validate_non_negative_index("mu", "P", P);
            validate_non_negative_index("mu", "(logical_neq(pooling_type, 0) ? 1 : 0 )", (logical_neq(pooling_type, 0) ? 1 : 0 ));
            num_params_r__ += (P * (logical_neq(pooling_type, 0) ? 1 : 0 ));
            current_statement_begin__ = 62;
            validate_non_negative_index("L_Omega", "P", P);
            validate_non_negative_index("L_Omega", "P", P);
            validate_non_negative_index("L_Omega", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
            num_params_r__ += (((P * (P - 1)) / 2) * (logical_eq(pooling_type, 1) ? 1 : 0 ));
            current_statement_begin__ = 63;
            validate_non_negative_index("hypersd", "P", P);
            validate_non_negative_index("hypersd", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
            num_params_r__ += (P * (logical_eq(pooling_type, 1) ? 1 : 0 ));
            current_statement_begin__ = 64;
            validate_non_negative_index("eta", "P", P);
            validate_non_negative_index("eta", "K", K);
            validate_non_negative_index("eta", "(logical_neq(pooling_type, 2) ? 1 : 0 )", (logical_neq(pooling_type, 2) ? 1 : 0 ));
            num_params_r__ += ((P * K) * (logical_neq(pooling_type, 2) ? 1 : 0 ));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_mutau() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 61;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "P", P);
        validate_non_negative_index("mu", "(logical_neq(pooling_type, 0) ? 1 : 0 )", (logical_neq(pooling_type, 0) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec((logical_neq(pooling_type, 0) ? 1 : 0 ),P));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu((logical_neq(pooling_type, 0) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, 1>(P));
        size_t mu_j_1_max__ = P;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                mu[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t mu_i_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(mu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 62;
        if (!(context__.contains_r("L_Omega")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable L_Omega missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("L_Omega");
        pos__ = 0U;
        validate_non_negative_index("L_Omega", "P", P);
        validate_non_negative_index("L_Omega", "P", P);
        validate_non_negative_index("L_Omega", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "L_Omega", "matrix_d", context__.to_vec((logical_eq(pooling_type, 1) ? 1 : 0 ),P,P));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > L_Omega((logical_eq(pooling_type, 1) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, P));
        size_t L_Omega_j_2_max__ = P;
        size_t L_Omega_j_1_max__ = P;
        size_t L_Omega_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < L_Omega_k_0_max__; ++k_0__) {
                    L_Omega[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t L_Omega_i_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < L_Omega_i_0_max__; ++i_0__) {
            try {
                writer__.cholesky_factor_corr_unconstrain(L_Omega[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable L_Omega: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 63;
        if (!(context__.contains_r("hypersd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hypersd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hypersd");
        pos__ = 0U;
        validate_non_negative_index("hypersd", "P", P);
        validate_non_negative_index("hypersd", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "hypersd", "vector_d", context__.to_vec((logical_eq(pooling_type, 1) ? 1 : 0 ),P));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > hypersd((logical_eq(pooling_type, 1) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, 1>(P));
        size_t hypersd_j_1_max__ = P;
        size_t hypersd_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < hypersd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < hypersd_k_0_max__; ++k_0__) {
                hypersd[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t hypersd_i_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < hypersd_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, hypersd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hypersd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 64;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "P", P);
        validate_non_negative_index("eta", "K", K);
        validate_non_negative_index("eta", "(logical_neq(pooling_type, 2) ? 1 : 0 )", (logical_neq(pooling_type, 2) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "eta", "matrix_d", context__.to_vec((logical_neq(pooling_type, 2) ? 1 : 0 ),P,K));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > eta((logical_neq(pooling_type, 2) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, K));
        size_t eta_j_2_max__ = K;
        size_t eta_j_1_max__ = P;
        size_t eta_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_k_0_max__; ++k_0__) {
                    eta[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t eta_i_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        for (size_t i_0__ = 0; i_0__ < eta_i_0_max__; ++i_0__) {
            try {
                writer__.matrix_unconstrain(eta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 61;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mu;
            size_t mu_d_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
            mu.reserve(mu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu.push_back(in__.vector_constrain(P, lp__));
                else
                    mu.push_back(in__.vector_constrain(P));
            }
            current_statement_begin__ = 62;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > L_Omega;
            size_t L_Omega_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            L_Omega.reserve(L_Omega_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < L_Omega_d_0_max__; ++d_0__) {
                if (jacobian__)
                    L_Omega.push_back(in__.cholesky_factor_corr_constrain(P, lp__));
                else
                    L_Omega.push_back(in__.cholesky_factor_corr_constrain(P));
            }
            current_statement_begin__ = 63;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > hypersd;
            size_t hypersd_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            hypersd.reserve(hypersd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < hypersd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    hypersd.push_back(in__.vector_lb_constrain(0, P, lp__));
                else
                    hypersd.push_back(in__.vector_lb_constrain(0, P));
            }
            current_statement_begin__ = 64;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > eta;
            size_t eta_d_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
            eta.reserve(eta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < eta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    eta.push_back(in__.matrix_constrain(P, K, lp__));
                else
                    eta.push_back(in__.matrix_constrain(P, K));
            }
            // transformed parameters
            current_statement_begin__ = 68;
            validate_non_negative_index("theta_k", "P", P);
            validate_non_negative_index("theta_k", "K", K);
            validate_non_negative_index("theta_k", "(logical_neq(pooling_type, 2) ? 1 : 0 )", (logical_neq(pooling_type, 2) ? 1 : 0 ));
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > theta_k((logical_neq(pooling_type, 2) ? 1 : 0 ), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(P, K));
            stan::math::initialize(theta_k, DUMMY_VAR__);
            stan::math::fill(theta_k, DUMMY_VAR__);
            current_statement_begin__ = 69;
            validate_non_negative_index("tau", "P", P);
            validate_non_negative_index("tau", "P", P);
            validate_non_negative_index("tau", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > tau((logical_eq(pooling_type, 1) ? 1 : 0 ), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(P, P));
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 71;
            if (as_bool(logical_eq(pooling_type, 0))) {
                current_statement_begin__ = 72;
                stan::model::assign(theta_k, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(eta, 1, "eta", 1), 
                            "assigning variable theta_k");
            }
            current_statement_begin__ = 73;
            if (as_bool(logical_eq(pooling_type, 1))) {
                current_statement_begin__ = 79;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(hypersd, 1, "hypersd", 1), get_base1(L_Omega, 1, "L_Omega", 1)), 
                            "assigning variable tau");
                current_statement_begin__ = 80;
                stan::model::assign(theta_k, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(rep_matrix(get_base1(mu, 1, "mu", 1), K), multiply(get_base1(tau, 1, "tau", 1), get_base1(eta, 1, "eta", 1))), 
                            "assigning variable theta_k");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 68;
            size_t theta_k_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
            size_t theta_k_j_1_max__ = P;
            size_t theta_k_j_2_max__ = K;
            for (size_t k_0__ = 0; k_0__ < theta_k_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < theta_k_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(theta_k[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: theta_k" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_k: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 69;
            size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            size_t tau_j_1_max__ = P;
            size_t tau_j_2_max__ = P;
            for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < tau_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(tau[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: tau" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            // model body
            current_statement_begin__ = 90;
            if (as_bool(logical_neq(pooling_type, 0))) {
                current_statement_begin__ = 91;
                if (as_bool(logical_eq(prior_hypermean_fam, 3))) {
                    current_statement_begin__ = 92;
                    lp_accum__.add(multi_normal_log<propto__>(get_base1(mu, 1, "mu", 1), prior_hypermean_mean, prior_hypermean_scale));
                }
            } else {
                current_statement_begin__ = 94;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 95;
                    lp_accum__.add(multi_normal_log<propto__>(stan::model::rvalue(get_base1(eta, 1, "eta", 1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), "eta[1]"), prior_hypermean_mean, prior_hypermean_scale));
                }
            }
            current_statement_begin__ = 99;
            if (as_bool(logical_eq(pooling_type, 1))) {
                current_statement_begin__ = 100;
                lp_accum__.add(std_normal_log<propto__>(to_vector(get_base1(eta, 1, "eta", 1))));
                current_statement_begin__ = 102;
                for (int p = 1; p <= P; ++p) {
                    current_statement_begin__ = 103;
                    lp_accum__.add(prior_increment_real(prior_hypersd_fam, get_base1(get_base1(hypersd, 1, "hypersd", 1), p, "hypersd", 2), prior_hypersd_val, pstream__));
                }
                current_statement_begin__ = 106;
                lp_accum__.add(lkj_corr_cholesky_log<propto__>(get_base1(L_Omega, 1, "L_Omega", 1), prior_hypercor_val));
            }
            current_statement_begin__ = 109;
            if (as_bool((primitive_value(logical_eq(pooling_type, 1)) && primitive_value(logical_gt(K, 0))))) {
                current_statement_begin__ = 110;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 112;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 113;
                        lp_accum__.add(normal_log<propto__>(get_base1(get_base1(theta_hat_k, p, "theta_hat_k", 1), k, "theta_hat_k", 2), get_base1(get_base1(theta_k, 1, "theta_k", 1), p, k, "theta_k", 2), get_base1(get_base1(se_theta_k, p, "se_theta_k", 1), k, "se_theta_k", 2)));
                    }
                }
            }
            current_statement_begin__ = 116;
            if (as_bool((primitive_value(logical_eq(pooling_type, 2)) && primitive_value(logical_gt(K, 0))))) {
                current_statement_begin__ = 117;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 118;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 119;
                        lp_accum__.add(normal_log<propto__>(get_base1(get_base1(theta_hat_k, p, "theta_hat_k", 1), k, "theta_hat_k", 2), get_base1(get_base1(mu, 1, "mu", 1), p, "mu", 2), get_base1(get_base1(se_theta_k, p, "se_theta_k", 1), k, "se_theta_k", 2)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("L_Omega");
        names__.push_back("hypersd");
        names__.push_back("eta");
        names__.push_back("theta_k");
        names__.push_back("tau");
        names__.push_back("logpd");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((logical_neq(pooling_type, 0) ? 1 : 0 ));
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(pooling_type, 1) ? 1 : 0 ));
        dims__.push_back(P);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(pooling_type, 1) ? 1 : 0 ));
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_neq(pooling_type, 2) ? 1 : 0 ));
        dims__.push_back(P);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_neq(pooling_type, 2) ? 1 : 0 ));
        dims__.push_back(P);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(pooling_type, 1) ? 1 : 0 ));
        dims__.push_back(P);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(K_test, 0) ? 1 : 0 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_mutau_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu;
        size_t mu_d_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        mu.reserve(mu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
            mu.push_back(in__.vector_constrain(P));
        }
        size_t mu_j_1_max__ = P;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                vars__.push_back(mu[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > L_Omega;
        size_t L_Omega_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        L_Omega.reserve(L_Omega_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < L_Omega_d_0_max__; ++d_0__) {
            L_Omega.push_back(in__.cholesky_factor_corr_constrain(P));
        }
        size_t L_Omega_j_2_max__ = P;
        size_t L_Omega_j_1_max__ = P;
        size_t L_Omega_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < L_Omega_k_0_max__; ++k_0__) {
                    vars__.push_back(L_Omega[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > hypersd;
        size_t hypersd_d_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        hypersd.reserve(hypersd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < hypersd_d_0_max__; ++d_0__) {
            hypersd.push_back(in__.vector_lb_constrain(0, P));
        }
        size_t hypersd_j_1_max__ = P;
        size_t hypersd_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < hypersd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < hypersd_k_0_max__; ++k_0__) {
                vars__.push_back(hypersd[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > eta;
        size_t eta_d_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        eta.reserve(eta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < eta_d_0_max__; ++d_0__) {
            eta.push_back(in__.matrix_constrain(P, K));
        }
        size_t eta_j_2_max__ = K;
        size_t eta_j_1_max__ = P;
        size_t eta_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_k_0_max__; ++k_0__) {
                    vars__.push_back(eta[k_0__](j_1__, j_2__));
                }
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 68;
            validate_non_negative_index("theta_k", "P", P);
            validate_non_negative_index("theta_k", "K", K);
            validate_non_negative_index("theta_k", "(logical_neq(pooling_type, 2) ? 1 : 0 )", (logical_neq(pooling_type, 2) ? 1 : 0 ));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > theta_k((logical_neq(pooling_type, 2) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, K));
            stan::math::initialize(theta_k, DUMMY_VAR__);
            stan::math::fill(theta_k, DUMMY_VAR__);
            current_statement_begin__ = 69;
            validate_non_negative_index("tau", "P", P);
            validate_non_negative_index("tau", "P", P);
            validate_non_negative_index("tau", "(logical_eq(pooling_type, 1) ? 1 : 0 )", (logical_eq(pooling_type, 1) ? 1 : 0 ));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > tau((logical_eq(pooling_type, 1) ? 1 : 0 ), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, P));
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 71;
            if (as_bool(logical_eq(pooling_type, 0))) {
                current_statement_begin__ = 72;
                stan::model::assign(theta_k, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(eta, 1, "eta", 1), 
                            "assigning variable theta_k");
            }
            current_statement_begin__ = 73;
            if (as_bool(logical_eq(pooling_type, 1))) {
                current_statement_begin__ = 79;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            diag_pre_multiply(get_base1(hypersd, 1, "hypersd", 1), get_base1(L_Omega, 1, "L_Omega", 1)), 
                            "assigning variable tau");
                current_statement_begin__ = 80;
                stan::model::assign(theta_k, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            add(rep_matrix(get_base1(mu, 1, "mu", 1), K), multiply(get_base1(tau, 1, "tau", 1), get_base1(eta, 1, "eta", 1))), 
                            "assigning variable theta_k");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_k_j_2_max__ = K;
                size_t theta_k_j_1_max__ = P;
                size_t theta_k_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
                for (size_t j_2__ = 0; j_2__ < theta_k_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < theta_k_k_0_max__; ++k_0__) {
                            vars__.push_back(theta_k[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t tau_j_2_max__ = P;
                size_t tau_j_1_max__ = P;
                size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
                for (size_t j_2__ = 0; j_2__ < tau_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                            vars__.push_back(tau[k_0__](j_1__, j_2__));
                        }
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 123;
            validate_non_negative_index("logpd", "(logical_gt(K_test, 0) ? 1 : 0 )", (logical_gt(K_test, 0) ? 1 : 0 ));
            std::vector<double> logpd((logical_gt(K_test, 0) ? 1 : 0 ), double(0));
            stan::math::initialize(logpd, DUMMY_VAR__);
            stan::math::fill(logpd, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 124;
            if (as_bool(logical_gt(K_test, 0))) {
                current_statement_begin__ = 125;
                stan::model::assign(logpd, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable logpd");
                current_statement_begin__ = 126;
                for (int k = 1; k <= K_test; ++k) {
                    current_statement_begin__ = 127;
                    for (int p = 1; p <= P; ++p) {
                        current_statement_begin__ = 128;
                        if (as_bool(logical_eq(pooling_type, 1))) {
                            current_statement_begin__ = 129;
                            stan::model::assign(logpd, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(logpd, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "logpd") + normal_log(get_base1(get_base1(test_theta_hat_k, p, "test_theta_hat_k", 1), k, "test_theta_hat_k", 2), get_base1(mu, 1, "mu", 1), stan::math::sqrt((pow(get_base1(get_base1(tau, 1, "tau", 1), p, p, "tau", 2), 2) + pow(get_base1(get_base1(test_se_theta_k, p, "test_se_theta_k", 1), k, "test_se_theta_k", 2), 2))))), 
                                        "assigning variable logpd");
                        }
                        current_statement_begin__ = 131;
                        if (as_bool(logical_eq(pooling_type, 2))) {
                            current_statement_begin__ = 132;
                            stan::model::assign(logpd, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(logpd, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "logpd") + normal_log(get_base1(get_base1(test_theta_hat_k, p, "test_theta_hat_k", 1), k, "test_theta_hat_k", 2), get_base1(mu, 1, "mu", 1), stan::math::sqrt(pow(get_base1(get_base1(test_se_theta_k, p, "test_se_theta_k", 1), k, "test_se_theta_k", 2), 2)))), 
                                        "assigning variable logpd");
                        }
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 123;
            size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
            for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
                vars__.push_back(logpd[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_mutau";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = P;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_2_max__ = P;
        size_t L_Omega_j_1_max__ = P;
        size_t L_Omega_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < L_Omega_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < L_Omega_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "L_Omega" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t hypersd_j_1_max__ = P;
        size_t hypersd_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < hypersd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < hypersd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "hypersd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_j_2_max__ = K;
        size_t eta_j_1_max__ = P;
        size_t eta_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_j_2_max__ = K;
            size_t theta_k_j_1_max__ = P;
            size_t theta_k_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
            for (size_t j_2__ = 0; j_2__ < theta_k_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < theta_k_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "theta_k" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t tau_j_2_max__ = P;
            size_t tau_j_1_max__ = P;
            size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            for (size_t j_2__ = 0; j_2__ < tau_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "tau" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logpd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t mu_j_1_max__ = P;
        size_t mu_k_0_max__ = (logical_neq(pooling_type, 0) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L_Omega_j_1_max__ = ((P * (P - 1)) / 2);
        size_t L_Omega_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < L_Omega_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < L_Omega_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L_Omega" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t hypersd_j_1_max__ = P;
        size_t hypersd_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < hypersd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < hypersd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "hypersd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eta_j_2_max__ = K;
        size_t eta_j_1_max__ = P;
        size_t eta_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
        for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < eta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_k_j_2_max__ = K;
            size_t theta_k_j_1_max__ = P;
            size_t theta_k_k_0_max__ = (logical_neq(pooling_type, 2) ? 1 : 0 );
            for (size_t j_2__ = 0; j_2__ < theta_k_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < theta_k_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < theta_k_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "theta_k" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t tau_j_2_max__ = P;
            size_t tau_j_1_max__ = P;
            size_t tau_k_0_max__ = (logical_eq(pooling_type, 1) ? 1 : 0 );
            for (size_t j_2__ = 0; j_2__ < tau_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "tau" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t logpd_k_0_max__ = (logical_gt(K_test, 0) ? 1 : 0 );
        for (size_t k_0__ = 0; k_0__ < logpd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "logpd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_mutau_namespace::model_mutau stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
