% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nplcm.R
\name{nplcm}
\alias{nplcm}
\title{Fit nested partially-latent class models (highest-level wrapper function)}
\usage{
nplcm(data_nplcm, model_options, mcmc_options)
}
\arguments{
\item{data_nplcm}{Cases are on top of controls in the rows of diagnostic
test results and the covariate matrix. This is assumed by \code{baker} to automatically
write model files (\code{.bug}).
\itemize{
\item  \code{Mobs} A list of measurements of distinct qualities (Bronze-, Silver, and Gold-Standard:
\code{MBS},\code{MSS},\code{MGS}). The elements of the list
should include \code{MBS}, \code{MSS}, and \code{MGS}. If any of the component
is not available, please specify it as, e.g., \code{MGS=NULL}
(effectively deleting \code{MGS} from \code{Mobs}).
\itemize{
\item \code{MBS} a list of data frame of bronze-standard (BrS) measurements.
Rows are subjects, columns are causative agents (e.g., pathogen species).
We use \code{list} here to accommodate the possibility of multiple sets of BrS data.
They have imperfect sensitivity/specificity (e.g. nasopharyngeal polymerase chain
reaction - NPPCR).
\item \code{MSS} a list of data frame of silver-standard (SS) measurements.
Rows are subjects, columns are causative agents measured in specimen (e.g. blood culture).
These measurements have perfect specificity but imperfect sensitivity.
\item \code{MGS} a list of data frame of gold-standard (GS) measurements.
Rows are subject, columns are measured causative agents
These measurements have perfect sensitivity and specificity.
}

\item \code{Y} Vector of disease status: \code{1} for case, \code{0} for control.
\item \code{X} Covariate matrix. A subset of columns are primary covariates in cause-specific-
case-fraction (CSCF) functions and hence must be available for cases, and another subset
are covariates that are available in the cases and the controls.
The two sets of covariates may be identical, overlapping or completely different.
In general, this is not the design matrix for regression models,
because for enrollment date in a study which may have non-linear effect,
basis expansion is often needed for approximation.
}}

\item{model_options}{A list of model options: likelihood and prior.
\describe{
\item{\code{use_measurements}}{
A vector of characters strings; can be one or more from \code{"BrS"}, \code{"SS"}, \code{"GS"}.
}
\item{\code{likelihood}}{
\itemize{
\item{cause_list} The vector of causes (NB: specify);
\item{k_subclass} The number of nested subclasses in each
disease class (one of case classes or the control class; the same \code{k_subclass}
is assumed for each class) and each slice of BrS measurements.
\code{1} for conditional independence; larger than \code{1} for conditional dependence.
It is only available for BrS measurements. It is a vector of length equal to
the number of slices of BrS measurements;
\item{Eti_formula} Formula for etiology regressions. You can use
\code{\link[=s_date_Eti]{s_date_Eti()}} to specify the design matrix for \code{R} format enrollment date;
it will produce natural cubic spline basis. Specify \code{~ 1} if no regression is intended.
\item{FPR_formula}formula for false positive rates (FPR) regressions; see \code{\link[=formula]{formula()}}.
You can use \code{\link[=s_date_FPR]{s_date_FPR()}} to specify part of the design matrix for \code{R}
format enrollment date; it will produce penalized-spline basis (based on B-splines).
Specify \code{~ 1} if no regression is intended. (NB: If \code{effect="fixed"}, \code{\link[=dm_Rdate_FPR]{dm_Rdate_FPR()}}
will just specify a design matrix with appropriately standardized dates.)
}
}

\item{\code{prior}}{
\itemize{
\item{Eti_prior}Description of etiology prior (e.g., \code{overall_uniform} -
all hyperparameters are \code{1}; or \verb{0_1} - all hyperparameters are \code{0.1});
\item{TPR_prior}Description of priors for the measurements
(e.g., informative vs non-informative). Its length should be the same with \code{M_use}.
(NB: not sure what M use is...)
}
}
}}

\item{mcmc_options}{A list of Markov chain Monte Carlo (MCMC) options.
\itemize{
\item \code{debugstatus} Logical - whether to pause WinBUGS after it finishes
model fitting; (NB: is this obsolete? Test.)
\item \code{n.chains} Number of MCMC chains;
\item \code{n.burnin} Number of burn-in iterations;
\item \code{n.thin} To keep every other \code{n.thin} samples after burn-in period;
\item \code{individual.pred} \code{TRUE} to perform individual prediction (\code{Icat}
variables in the \code{.bug} file); \code{FALSE} otherwise;
\item \code{ppd} \code{TRUE} to simulate new data (\code{XXX.new}
variables in the \code{.bug} file) from the posterior predictive distribution (ppd);
\code{FALSE} otherwise;
\item \code{get.pEti} \code{TRUE} for getting posterior samples of individual etiologic fractions;
\code{FALSE} otherwise. For non-regression, or regression models with all discrete predictors,
by default this is \code{TRUE}, so no need to specify this entry. It is only relevant for regression models
with non-discrete covariates. Because individuals have distinct CSCFs at their specific covariate values,
it's easier to just store the posterior samples of the regression coefficients and reconstruct the pies afterwards,
rather than storing them through \code{JAGS}.
\item \code{result.folder} Path to folder storing the results;
\item \code{bugsmodel.dir} Path to \code{.bug} model files;
\item \code{jags.dir} Path to where JAGS is installed; if \code{NULL}, this will be set
to \code{jags.dir=""}.
}}
}
\value{
A \code{JAGS} output result, fitted by function \code{\link[R2jags:jags]{R2jags::jags2()}} from \code{R2jags}.
It is an object of class \code{nplcm} and \code{bugs}.
Current implemented models follow the hierarchy below:
\itemize{
\item no regression:  Fitted by at low level by \link{nplcm_fit_NoReg}

\item regression:
Given disease class (control or a class of cases with the same subset of causative agents):
\itemize{
\item local independence model for BrS measures:
Fitted at lower level by
\itemize{
\item \link{nplcm_fit_Reg_NoNest} deals with the setting with two sets of covariates,
one for CSCF regression and the other for FPR regression. The two sets of
covariates may be identical, overlapping or non-overlapping.
This function is called when there exists one or more than one discrete covariate among
the union of the two covariate sets. The method implemented by this function
directly lets FPR depend upon covariates.
This is different from Wu and Chen (2020+), which let the subclass
weights depend upon covariates. We implemented this function for methods comparison.
\item \link{nplcm_fit_Reg_discrete_predictor_NoNest} deals with the setting
with all discrete covariates for FPRs and CSCFs. The strata defined by the two sets of
covariates need not be identical, e.g., as a result of distinct sets of covariates. Again,
this is directly to let FPR be stratified by covariates, hence different from Wu and Chen (2020+)
We implemented this function for methods comparison.
}
\item local dependence model for BrS measures:
Fitted at lower level by \link{nplcm_fit_Reg_Nest}: This is the method introduced in
Wu and Chen (2020+): CSCF regression + case/control subclass weight regression.
It does not provide a specialized function for the setting with all discrete covariates.
}
}
}
\description{
Uses \code{JAGS} (OSX or Windows) operating system for Bayesian posterior inference
(see \code{README} file for an instruction to install \code{JAGS}). If running \code{JAGS} on windows,
please go to control panel to add the directory to \code{JAGS} into ENVIRONMENTAL VARIABLE.
}
\examples{

\donttest{
data(data_nplcm_noreg)
cause_list <- LETTERS[1:6]
J.BrS      <- 6
model_options_no_reg <- list(
  likelihood   = list(
    cause_list = cause_list,
    k_subclass = 2,
    Eti_formula = ~-1, # no covariate for the etiology regression
    FPR_formula = list(
      MBS1 =   ~-1)    # no covariate for the subclass weight regression
  ),
  use_measurements = c("BrS"), 
  # use bronze-standard data only for model estimation.
  prior= list(
    Eti_prior = overall_uniform(1,cause_list), 
    # Dirichlet(1,...,1) prior for the etiology.
    TPR_prior  = list(BrS = list(
      info  = "informative", # informative prior for TPRs
      input = "match_range", 
      # specify the informative prior for TPRs by specifying a plausible range.
      val = list(MBS1 = list(up =  list(rep(0.99,J.BrS)), 
                             # upper ranges: matched to 97.5\% quantile of a Beta prior
                             low = list(rep(0.55,J.BrS))))
      # lower ranges: matched to 2.5\% quantile of a Beta prior
    )
    )
  )
)     


set.seed(1)
# include stratification information in file name:
thedir    <- paste0(tempdir(),"_no_reg")

# create folders to store the model results 
dir.create(thedir, showWarnings = FALSE)
result_folder_no_reg <- file.path(thedir,paste("results",collapse="_"))
thedir <- result_folder_no_reg
dir.create(thedir, showWarnings = FALSE)

# options for MCMC chains:
mcmc_options_no_reg <- list(
  debugstatus = TRUE,
  n.chains = 1,
  n.itermcmc = as.integer(200), 
  n.burnin = as.integer(100), 
  n.thin = 1,
  individual.pred = TRUE, # <- must set to TRUE! <------- NOTE! 
  ppd = FALSE,
  result.folder = thedir,
  bugsmodel.dir = thedir
)

BrS_object_1 <- make_meas_object(patho = LETTERS[1:6], 
                                 specimen = "MBS", test = "1", 
                                 quality = "BrS", cause_list = cause_list)
clean_options <- list(BrS_objects = make_list(BrS_object_1))
# place the nplcm data and cleaning options into the results folder
dput(data_nplcm_noreg,file.path(thedir,"data_nplcm.txt")) 
dput(clean_options, file.path(thedir, "data_clean_options.txt"))

rjags::load.module("glm")

nplcm_noreg <- nplcm(data_nplcm_noreg,model_options_no_reg,mcmc_options_no_reg)


}


}
