% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBanterModelData.R
\name{getBanterModelData}
\alias{getBanterModelData}
\title{Extract Random Forest Model Data}
\usage{
getBanterModelData(x)
}
\arguments{
\item{x}{a \code{\link{banter_model}} object.}
}
\value{
a \code{\link{randomForest}} model object.
}
\description{
Extract BANTER event data used for the Random Forest model.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)
# run BANTER event model
bant.mdl <- runBanterModel(bant.mdl, ntree = 1000, sampsize = 1)

event.df <- getBanterModelData(bant.mdl)
head(event.df)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
