% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_bartBMA.R
\name{predict_bartBMA}
\alias{predict_bartBMA}
\title{Predictions for a new dataset using an existing bartbma object}
\usage{
predict_bartBMA(object, newdata)
}
\arguments{
\item{object}{A bartBMA object obtained using the barBMA function.}

\item{newdata}{Covariate matrix for new dataset.}
}
\value{
A vector of predictions for the new dataset.
}
\description{
This function produces predictions for a new dataset using a previously obtained bartBMA object.
}
\examples{
set.seed(100)
#simulate some data
N <- 100
p<- 100
epsilon <- rnorm(N)
xcov <- matrix(runif(N*p), nrow=N)
y <- sin(pi*xcov[,1]*xcov[,2]) + 20*(xcov[,3]-0.5)^2+10*xcov[,4]+5*xcov[,5]+epsilon
epsilontest <- rnorm(N)
xcovtest <- matrix(runif(N*p), nrow=N)
ytest <- sin(pi*xcovtest[,1]*xcovtest[,2]) + 20*(xcovtest[,3]-0.5)^2+10*xcovtest[,4]+
  5*xcovtest[,5]+epsilontest

#Train the object 
bart_bma_example <- bartBMA(x.train = xcov,y.train=y,x.test=xcovtest,zero_split = 1, 
                            only_max_num_trees = 1,split_rule_node = 0)
#Obtain the prediction intervals
predict_bartBMA(bart_bma_example,newdata=xcovtest)
}
