% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.bartcs}
\alias{summary.bartcs}
\title{Summary for \code{bartcs} object}
\usage{
\method{summary}{bartcs}(object, ...)
}
\arguments{
\item{object}{A \code{bartcs} object.}

\item{...}{Additional arguments. Not yet supported.}
}
\value{
Provide list with the following components

\item{model}{\code{separate_bart} or \code{single_bart}.}
\item{trt_value}{Treatment values for each treatment group:
\code{trt_treated} for the treatment group and \code{trt_control} for
the control group.}
\item{tree_params}{Parameters for the tree structure.}
\item{chain_params}{Parameters for MCMC chains.}
\item{gelman_rubin}{Gelman-Rubin diagnostic value.}
\item{outcome}{Summary of outcomes from the model. This includes
both aggregated outcome and individual outcomes from each MCMC chain.}
}
\description{
Provide summary for \code{bartcs} object.
}
\details{
\code{summary()} provides the Gelman-Rubin diagnostic value and
95\% posterior credible interval for both aggregated outcome and
individual outcomes from each MCMC chain.
}
\examples{
data(ihdp, package = "bartcs")
x <- single_bart(
  Y               = ihdp$y_factual,
  trt             = ihdp$treatment,
  X               = ihdp[, 6:30],
  num_tree        = 10,
  num_chain       = 2,
  num_post_sample = 20,
  num_burn_in     = 10,
  verbose         = FALSE
)
summary(x)

}
