% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_draft_prospects.R
\name{mlb_draft_prospects}
\alias{mlb_draft_prospects}
\title{\strong{Retrieve draft prospect information by year}}
\usage{
mlb_draft_prospects(year)
}
\arguments{
\item{year}{The year for which to return data}
}
\value{
Returns a tibble with information for every draft prospect for the year requested:\tabular{ll}{
   col_name \tab types \cr
   bis_player_id \tab integer \cr
   pick_round \tab character \cr
   pick_number \tab integer \cr
   rank \tab integer \cr
   scouting_report \tab character \cr
   blurb \tab character \cr
   headshot_link \tab character \cr
   is_drafted \tab logical \cr
   year \tab character \cr
   home_city \tab character \cr
   home_state \tab character \cr
   home_country \tab character \cr
   school_name \tab character \cr
   school_school_class \tab character \cr
   school_country \tab character \cr
   school_state \tab character \cr
   person_id \tab integer \cr
   person_full_name \tab character \cr
   person_link \tab character \cr
   person_first_name \tab character \cr
   person_last_name \tab character \cr
   person_birth_date \tab character \cr
   person_current_age \tab integer \cr
   person_birth_city \tab character \cr
   person_birth_state_province \tab character \cr
   person_birth_country \tab character \cr
   person_height \tab character \cr
   person_weight \tab integer \cr
   person_active \tab logical \cr
   person_use_name \tab character \cr
   person_middle_name \tab character \cr
   person_boxscore_name \tab character \cr
   person_gender \tab character \cr
   person_is_player \tab logical \cr
   person_is_verified \tab logical \cr
   person_draft_year \tab integer \cr
   person_name_first_last \tab character \cr
   person_name_slug \tab character \cr
   person_first_last_name \tab character \cr
   person_last_first_name \tab character \cr
   person_last_init_name \tab character \cr
   person_init_last_name \tab character \cr
   person_full_fml_name \tab character \cr
   person_full_lfm_name \tab character \cr
   person_strike_zone_top \tab numeric \cr
   person_strike_zone_bottom \tab numeric \cr
   person_primary_number \tab character \cr
   person_pronunciation \tab character \cr
   person_name_title \tab character \cr
   person_mlb_debut_date \tab character \cr
   person_name_matrilineal \tab character \cr
   person_nick_name \tab character \cr
   person_death_date \tab character \cr
   person_death_city \tab character \cr
   person_death_state_province \tab character \cr
   person_death_country \tab character \cr
   person_primary_position_code \tab character \cr
   person_primary_position_name \tab character \cr
   person_primary_position_type \tab character \cr
   person_primary_position_abbreviation \tab character \cr
   person_bat_side_code \tab character \cr
   person_bat_side_description \tab character \cr
   person_pitch_hand_code \tab character \cr
   person_pitch_hand_description \tab character \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   team_season \tab integer \cr
   team_team_code \tab character \cr
   team_file_code \tab character \cr
   team_abbreviation \tab character \cr
   team_team_name \tab character \cr
   team_location_name \tab character \cr
   team_first_year_of_play \tab character \cr
   team_short_name \tab character \cr
   team_franchise_name \tab character \cr
   team_club_name \tab character \cr
   team_all_star_status \tab character \cr
   team_active \tab logical \cr
   team_venue_id \tab integer \cr
   team_venue_name \tab character \cr
   team_venue_link \tab character \cr
   team_spring_venue_id \tab integer \cr
   team_spring_venue_link \tab character \cr
   team_league_id \tab integer \cr
   team_league_name \tab character \cr
   team_league_link \tab character \cr
   team_division_id \tab integer \cr
   team_division_name \tab character \cr
   team_division_link \tab character \cr
   team_sport_id \tab integer \cr
   team_sport_link \tab character \cr
   team_sport_name \tab character \cr
   team_spring_league_id \tab integer \cr
   team_spring_league_name \tab character \cr
   team_spring_league_link \tab character \cr
   team_spring_league_abbreviation \tab character \cr
   draft_type_code \tab character \cr
   draft_type_description \tab character \cr
}
}
\description{
\strong{Retrieve draft prospect information by year}
}
\examples{
\donttest{
  try(mlb_draft_prospects(year = 2020))
}
}
