% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_model_summary.R
\name{or_model_summary}
\alias{or_model_summary}
\title{Summarise a logistic regression model on the odds ratio scale}
\usage{
or_model_summary(
  model,
  conf_int = 1.96,
  print_intercept = FALSE,
  round_est = 3,
  round_p = 4
)
}
\arguments{
\item{model}{a model object with estimates on the log-odds scale.}

\item{conf_int}{a numeric used to calculate the confidence intervals. The
default of 1.96 gives the 95\% confidence interval.}

\item{print_intercept}{a logical flag indicating whether intercepts shall
be removed. All variables that start with "y>=" will be removed. If there
is a variable matching this pattern, it will also be removed!}

\item{round_est}{the number of decimals returned for estimates (odds ratios)
and confidence intervals.}

\item{round_p}{the number of decimals provided for p-values.}
}
\value{
a dataframe with the adjusted odds ratio, confidence intervals and
p-values.
}
\description{
This function summarises regression models that return data on the log-odds
scale and returns a dataframe with estimates, and confidence intervals as
odds ratios. P value are also provided.
Additionally, intercepts can be removed from the summary. This comes in
handy when ordinal logistic regression models are fit. Ordinal regression
models (such as proportional odds models) usually result in many intercepts
that are not really of interest.
This function is also compatible with models obtained from multiply imputed
datasets, for example models fitted with \code{Hmisc::fit.mult.impute()}.
}
\details{
CAVE! The function does not check whether your estimates are on the
log-odds scale. It will do the transformation no matter what!
}
\examples{
# fit a logistic model
mod <- glm(formula = am ~ mpg + cyl, data = mtcars, family = binomial())

or_model_summary(model = mod)

}
\author{
Till D. Best
}
