% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableHtmlRenderer.R
\docType{class}
\name{TableHtmlRenderer}
\alias{TableHtmlRenderer}
\title{R6 class that renders a table in HTML.}
\format{
\code{\link{R6Class}} object.
}
\description{
The `TableHtmlRenderer` class creates a HTML representation of a table.
}
\examples{
# This class is for internal use only.  It is
# created only by the BasicTable class when rendering to HTML.
# See the package vignettes for more information about outputs.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
tbl$renderTable()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TableHtmlRenderer$new()}}
\item \href{#method-getTableHtml}{\code{TableHtmlRenderer$getTableHtml()}}
\item \href{#method-clone}{\code{TableHtmlRenderer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new `TableHtmlRenderer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableHtmlRenderer$new(parentTable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTableHtml"></a>}}
\if{latex}{\out{\hypertarget{method-getTableHtml}{}}}
\subsection{Method \code{getTableHtml()}}{
Generate a HTML representation of the table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableHtmlRenderer$getTableHtml(styleNamePrefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple tables exist.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing HTML tags from the `htmltools` package.
Convert this to a character variable using `as.character()`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableHtmlRenderer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
