% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_exnex}
\alias{setup_exnex}
\title{Setup EXNEX Design Object}
\usage{
setup_exnex(
  k,
  p0,
  basket_mean = NULL,
  basket_sd = 100,
  mu_mean = NULL,
  mu_sd = 100
)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{basket_mean}{Mean of the normal prior distribution of the individual
thetas (NEX part). See details.}

\item{basket_sd}{Standard deviation of the normal prior distribution of the
individual thetas (NEX part).}

\item{mu_mean}{Mean of the normal prior exchangeability distribution for
the mean of the thetas (EX part). See details.}

\item{mu_sd}{Standard deviation of the normal prior exchangeability
distribution for the mean of the thetas (EX part).}
}
\value{
An S3 object of class \code{exnex}
}
\description{
Setup EXNEX Design Object
}
\details{
The class \code{exnex} implements the EXNEX model proposed by
Neuenschwander et al. (2016). Methods for this class are mostly wrappers
for functions from the package \code{bhmbasket}.

In the EXNEX model the thetas of all baskets are modeled as a mixture
of individual models and a Bayesian Hierarchical Model with a fixed
mixture weight w. If \code{mu_mean} and \code{basket_mean} are \code{NULL}
then they are set to logit(p0).
Note that Neuenschwander et al. (2016) use different prior means and
standard deviations. The default values here are used for better comparison
with the BHM model (see \code{\link{setup_bhm}}).
}
\examples{
design_exnex <- setup_exnex(k = 3, p0 = 0.2)
}
\references{
Neuenschwander, B., Wandel, S., Roychoudhury, S., & Bailey, S.
(2016). Robust exchangeability designs for early phase clinical trials with
multiple strata. Pharmaceutical statistics, 15(2), 123-134.
}
