% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconfig.R
\name{batch_reconfig_fileset}
\alias{batch_reconfig_fileset}
\title{Reconfigures Batch Processing File Set}
\usage{
batch_reconfig_fileset(path, regexp = NULL, recurse = NULL)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{regexp}{A string of a regular expression. Only non-hidden file names
which match the regular expression will be batch processed.}

\item{recurse}{A flag specifying whether to recurse into path's subdirectories.}
}
\value{
An invisible character vector of the paths to the files
remaining to be processed.
}
\description{
Updates the regular expression and/or recurse argument  that were provided
when a directory was configured (using \code{\link[=batch_config]{batch_config()}}).
}
\details{
\code{batch_reconfig_fileset()} is useful for including or excluding particular files.

It should be noted that \code{batch_reconfig_fun()} does not alter the
configuration time.

In order to process previously failed files \code{\link[=batch_run]{batch_run()}}
should be called with \code{failed = NA} or \code{failed = TRUE}.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_config_read(path)
batch_reconfig_fileset(path, regexp = "file\\\\d+[.]csv$")
batch_config_read(path)
batch_cleanup(path, force = TRUE, remaining = TRUE)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}} and \code{\link[=batch_config]{batch_config()}}
}
