% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctions.R
\name{cfHandleUnknownSubmitError}
\alias{cfHandleUnknownSubmitError}
\title{Cluster Functions Helper to Handle Unknown Errors}
\usage{
cfHandleUnknownSubmitError(cmd, exit.code, output)
}
\arguments{
\item{cmd}{[\code{character(1)}]\cr
OS command used to submit the job, e.g. qsub.}

\item{exit.code}{[\code{integer(1)}]\cr
Exit code of the OS command, should not be 0.}

\item{output}{[\code{character}]\cr
Output of the OS command, hopefully an informative error message.
If these are multiple lines in a vector, they are automatically joined.}
}
\value{
[\code{\link{SubmitJobResult}}].
}
\description{
This function is only intended for use in your own cluster functions implementation.

Simply constructs a \code{\link{SubmitJobResult}} object with status code 101, NA as batch id and
an informative error message containing the output of the OS command in \code{output}.
}
\seealso{
Other ClusterFunctionsHelper: \code{\link{cfBrewTemplate}},
  \code{\link{cfKillJob}},
  \code{\link{cfReadBrewTemplate}},
  \code{\link{makeClusterFunctions}},
  \code{\link{makeSubmitJobResult}},
  \code{\link{runOSCommand}}
}
\concept{ClusterFunctionsHelper}
