% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadRegistry.R
\name{loadRegistry}
\alias{loadRegistry}
\title{Load a Registry from the File System}
\usage{
loadRegistry(file.dir, work.dir = NULL, conf.file = findConfFile(),
  make.default = TRUE, writeable = FALSE)
}
\arguments{
\item{file.dir}{[\code{character(1)}]\cr
  Path where all files of the registry are saved.
  Default is directory \dQuote{registry} in the current working directory.
  The provided path will get normalized unless it is given relative to the home directory
  (i.e., starting with \dQuote{~}). Note that some templates do not handle relative paths well.

  If you pass \code{NA}, a temporary directory will be used.
  This way, you can create disposable registries for \code{\link{btlapply}} or examples.
  By default, the temporary directory \code{\link[base]{tempdir}()} will be used.
  If you want to use another directory, e.g. a directory which is shared between nodes,
  you can set it in your configuration file by setting the variable \code{temp.dir}.}

\item{work.dir}{[\code{character(1)}]\cr
  Working directory for R process for running jobs.
  Defaults to the working directory currently set during Registry construction (see \code{\link[base]{getwd}}).
  \code{loadRegistry} uses the stored \code{work.dir}, but you may also explicitly overwrite it,
  e.g., after switching to another system.

  The provided path will get normalized unless it is given relative to the home directory
  (i.e., starting with \dQuote{~}). Note that some templates do not handle relative paths well.}

\item{conf.file}{[\code{character(1)}]\cr
  Path to a configuration file which is sourced while the registry is created.
  For example, you can set cluster functions or default resources in it.
  The script is executed inside the environment of the registry after the defaults for all variables are set,
  thus you can set and overwrite slots, e.g. \code{default.resources = list(walltime = 3600)} to set default resources.

  The file lookup defaults to a heuristic which first tries to read \dQuote{batchtools.conf.R} in the current working directory.
  If not found, it looks for a configuration file \dQuote{config.R} in the OS dependent user configuration directory
  as reported by via \code{rappdirs::user_config_dir("batchtools", expand = FALSE)} (e.g., on linux this
  usually resolves to \dQuote{~/.config/batchtools/config.R}).
  If this file is also not found, the heuristic finally tries to read the file \dQuote{.batchtools.conf.R} in the
  home directory (\dQuote{~}).
  Set to \code{character(0)} if you want to disable this heuristic.}

\item{make.default}{[\code{logical(1)}]\cr
If set to \code{TRUE}, the created registry is saved inside the package
namespace and acts as default registry. You might want to switch this
off if you work with multiple registries simultaneously.
Default is \code{TRUE}.}

\item{writeable}{[\code{logical(1)}]\cr
Loads the registry in read-write mode. Default is \code{FALSE}.}
}
\value{
[\code{\link{Registry}}].
}
\description{
Loads a registry from its \code{file.dir}.

Multiple R sessions accessing the same registry simultaneously can lead to database inconsistencies.
Here, it does not matter if the sessions run on the same system or different systems via a file system mount.

If you just need to check on the status or peek into some preliminary results, you can load the registry in a
read-only mode by setting \code{writeable} to \code{FALSE}.
All operations that need to change the registry will raise an exception in this mode.
Files communicated back by the computational nodes are parsed to update the registry in memory, but remain on the file system
in order to be read and cleaned up by an R session with read-write access.

A heuristic tries to detect if the registry has been altered in the background.
However, you should not completely rely on it.
Thus, set to \code{writeable} to \code{TRUE} if and only if you are absolutely sure other R processes are terminated.
}
\seealso{
Other Registry: \code{\link{clearRegistry}},
  \code{\link{getDefaultRegistry}},
  \code{\link{makeRegistry}}, \code{\link{removeRegistry}},
  \code{\link{saveRegistry}}, \code{\link{sweepRegistry}},
  \code{\link{syncRegistry}}
}
