// Generated by rstantools.  Do not edit by hand.

/*
    bayes4psy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bayes4psy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bayes4psy.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_linear_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 13, column 2 to column 18)",
                                                      " (in 'string', line 14, column 2 to column 17)",
                                                      " (in 'string', line 15, column 2 to column 27)",
                                                      " (in 'string', line 17, column 2 to column 12)",
                                                      " (in 'string', line 18, column 2 to column 12)",
                                                      " (in 'string', line 19, column 2 to column 21)",
                                                      " (in 'string', line 20, column 2 to column 24)",
                                                      " (in 'string', line 21, column 2 to column 24)",
                                                      " (in 'string', line 22, column 2 to column 24)",
                                                      " (in 'string', line 27, column 2 to column 13)",
                                                      " (in 'string', line 35, column 4 to column 50)",
                                                      " (in 'string', line 34, column 29 to line 36, column 3)",
                                                      " (in 'string', line 34, column 9 to line 36, column 3)",
                                                      " (in 'string', line 33, column 4 to column 51)",
                                                      " (in 'string', line 32, column 29 to line 34, column 3)",
                                                      " (in 'string', line 32, column 9 to line 36, column 3)",
                                                      " (in 'string', line 31, column 4 to column 52)",
                                                      " (in 'string', line 30, column 29 to line 32, column 3)",
                                                      " (in 'string', line 30, column 9 to line 36, column 3)",
                                                      " (in 'string', line 29, column 4 to column 53)",
                                                      " (in 'string', line 28, column 22 to line 30, column 3)",
                                                      " (in 'string', line 28, column 2 to line 36, column 3)",
                                                      " (in 'string', line 38, column 2 to column 9)",
                                                      " (in 'string', line 46, column 4 to column 53)",
                                                      " (in 'string', line 45, column 29 to line 47, column 3)",
                                                      " (in 'string', line 45, column 9 to line 47, column 3)",
                                                      " (in 'string', line 44, column 4 to column 54)",
                                                      " (in 'string', line 43, column 29 to line 45, column 3)",
                                                      " (in 'string', line 43, column 9 to line 47, column 3)",
                                                      " (in 'string', line 42, column 4 to column 55)",
                                                      " (in 'string', line 41, column 29 to line 43, column 3)",
                                                      " (in 'string', line 41, column 9 to line 47, column 3)",
                                                      " (in 'string', line 40, column 4 to column 56)",
                                                      " (in 'string', line 39, column 22 to line 41, column 3)",
                                                      " (in 'string', line 39, column 2 to line 47, column 3)",
                                                      " (in 'string', line 49, column 2 to column 9)",
                                                      " (in 'string', line 57, column 4 to column 50)",
                                                      " (in 'string', line 56, column 29 to line 58, column 3)",
                                                      " (in 'string', line 56, column 9 to line 58, column 3)",
                                                      " (in 'string', line 55, column 4 to column 51)",
                                                      " (in 'string', line 54, column 29 to line 56, column 3)",
                                                      " (in 'string', line 54, column 9 to line 58, column 3)",
                                                      " (in 'string', line 53, column 4 to column 52)",
                                                      " (in 'string', line 52, column 29 to line 54, column 3)",
                                                      " (in 'string', line 52, column 9 to line 58, column 3)",
                                                      " (in 'string', line 51, column 4 to column 53)",
                                                      " (in 'string', line 50, column 22 to line 52, column 3)",
                                                      " (in 'string', line 50, column 2 to line 58, column 3)",
                                                      " (in 'string', line 60, column 2 to column 9)",
                                                      " (in 'string', line 68, column 4 to column 53)",
                                                      " (in 'string', line 67, column 29 to line 69, column 3)",
                                                      " (in 'string', line 67, column 9 to line 69, column 3)",
                                                      " (in 'string', line 66, column 4 to column 54)",
                                                      " (in 'string', line 65, column 29 to line 67, column 3)",
                                                      " (in 'string', line 65, column 9 to line 69, column 3)",
                                                      " (in 'string', line 64, column 4 to column 55)",
                                                      " (in 'string', line 63, column 29 to line 65, column 3)",
                                                      " (in 'string', line 63, column 9 to line 69, column 3)",
                                                      " (in 'string', line 62, column 4 to column 56)",
                                                      " (in 'string', line 61, column 22 to line 63, column 3)",
                                                      " (in 'string', line 61, column 2 to line 69, column 3)",
                                                      " (in 'string', line 71, column 2 to column 9)",
                                                      " (in 'string', line 79, column 4 to column 50)",
                                                      " (in 'string', line 78, column 29 to line 80, column 3)",
                                                      " (in 'string', line 78, column 9 to line 80, column 3)",
                                                      " (in 'string', line 77, column 4 to column 51)",
                                                      " (in 'string', line 76, column 29 to line 78, column 3)",
                                                      " (in 'string', line 76, column 9 to line 80, column 3)",
                                                      " (in 'string', line 75, column 4 to column 52)",
                                                      " (in 'string', line 74, column 29 to line 76, column 3)",
                                                      " (in 'string', line 74, column 9 to line 80, column 3)",
                                                      " (in 'string', line 73, column 4 to column 53)",
                                                      " (in 'string', line 72, column 22 to line 74, column 3)",
                                                      " (in 'string', line 72, column 2 to line 80, column 3)",
                                                      " (in 'string', line 82, column 2 to column 9)",
                                                      " (in 'string', line 90, column 4 to column 53)",
                                                      " (in 'string', line 89, column 29 to line 91, column 3)",
                                                      " (in 'string', line 89, column 9 to line 91, column 3)",
                                                      " (in 'string', line 88, column 4 to column 54)",
                                                      " (in 'string', line 87, column 29 to line 89, column 3)",
                                                      " (in 'string', line 87, column 9 to line 91, column 3)",
                                                      " (in 'string', line 86, column 4 to column 55)",
                                                      " (in 'string', line 85, column 29 to line 87, column 3)",
                                                      " (in 'string', line 85, column 9 to line 91, column 3)",
                                                      " (in 'string', line 84, column 4 to column 56)",
                                                      " (in 'string', line 83, column 22 to line 85, column 3)",
                                                      " (in 'string', line 83, column 2 to line 91, column 3)",
                                                      " (in 'string', line 92, column 2 to column 32)",
                                                      " (in 'string', line 93, column 2 to column 31)",
                                                      " (in 'string', line 94, column 2 to column 32)",
                                                      " (in 'string', line 96, column 4 to column 64)",
                                                      " (in 'string', line 95, column 2 to line 96, column 64)",
                                                      " (in 'string', line 2, column 2 to column 17)",
                                                      " (in 'string', line 3, column 2 to column 17)",
                                                      " (in 'string', line 4, column 9 to column 10)",
                                                      " (in 'string', line 4, column 2 to column 14)",
                                                      " (in 'string', line 5, column 9 to column 10)",
                                                      " (in 'string', line 5, column 2 to column 14)",
                                                      " (in 'string', line 6, column 17 to column 18)",
                                                      " (in 'string', line 6, column 2 to column 20)",
                                                      " (in 'string', line 8, column 2 to column 24)",
                                                      " (in 'string', line 9, column 2 to column 20)",
                                                      " (in 'string', line 13, column 9 to column 10)",
                                                      " (in 'string', line 14, column 9 to column 10)",
                                                      " (in 'string', line 15, column 18 to column 19)"};
#include <stan_meta_header.hpp>
class model_linear final : public model_base_crtp<model_linear> {
private:
  int n;
  int m;
  Eigen::Matrix<double, -1, 1> x;
  Eigen::Matrix<double, -1, 1> y;
  std::vector<int> s;
  std::vector<int> p_ids;
  std::vector<double> p_values;
 
public:
  ~model_linear() { }
  
  inline std::string model_name() const final { return "model_linear"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_linear(stan::io::var_context& context__,
               unsigned int random_seed__ = 0,
               std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_linear_namespace::model_linear";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 93;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 93;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 93;
      current_statement__ = 93;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 94;
      context__.validate_dims("data initialization","m","int",
          context__.to_vec());
      m = std::numeric_limits<int>::min();
      
      current_statement__ = 94;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 94;
      current_statement__ = 94;
      check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 95;
      validate_non_negative_index("x", "n", n);
      current_statement__ = 96;
      context__.validate_dims("data initialization","x","double",
          context__.to_vec(n));
      x = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(x, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> x_flat__;
        current_statement__ = 96;
        assign(x_flat__, nil_index_list(), context__.vals_r("x"),
          "assigning variable x_flat__");
        current_statement__ = 96;
        pos__ = 1;
        current_statement__ = 96;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 96;
          assign(x, cons_list(index_uni(sym1__), nil_index_list()),
            x_flat__[(pos__ - 1)], "assigning variable x");
          current_statement__ = 96;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 97;
      validate_non_negative_index("y", "n", n);
      current_statement__ = 98;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(n));
      y = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 98;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 98;
        pos__ = 1;
        current_statement__ = 98;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 98;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 98;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 99;
      validate_non_negative_index("s", "n", n);
      current_statement__ = 100;
      context__.validate_dims("data initialization","s","int",
          context__.to_vec(n));
      s = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 100;
      assign(s, nil_index_list(), context__.vals_i("s"),
        "assigning variable s");
      current_statement__ = 100;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 100;
        current_statement__ = 100;
        check_greater_or_equal(function__, "s[sym1__]", s[(sym1__ - 1)], 0);}
      current_statement__ = 101;
      context__.validate_dims("data initialization","p_ids","int",
          context__.to_vec(6));
      p_ids = std::vector<int>(6, std::numeric_limits<int>::min());
      
      current_statement__ = 101;
      assign(p_ids, nil_index_list(), context__.vals_i("p_ids"),
        "assigning variable p_ids");
      current_statement__ = 101;
      for (int sym1__ = 1; sym1__ <= 6; ++sym1__) {
        current_statement__ = 101;
        current_statement__ = 101;
        check_greater_or_equal(function__, "p_ids[sym1__]",
                               p_ids[(sym1__ - 1)], 0);}
      current_statement__ = 102;
      context__.validate_dims("data initialization","p_values","double",
          context__.to_vec(12));
      p_values = std::vector<double>(12, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 102;
      assign(p_values, nil_index_list(), context__.vals_r("p_values"),
        "assigning variable p_values");
      current_statement__ = 103;
      validate_non_negative_index("alpha", "m", m);
      current_statement__ = 104;
      validate_non_negative_index("beta", "m", m);
      current_statement__ = 105;
      validate_non_negative_index("sigma", "m", m);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += m;
      num_params_r__ += m;
      num_params_r__ += m;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_linear_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> alpha;
      alpha = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 1;
      alpha = in__.vector(m);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta = in__.vector(m);
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma;
      sigma = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(sigma, DUMMY_VAR__);
      
      current_statement__ = 3;
      sigma = in__.vector(m);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 3;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      local_scalar_t__ mu_a;
      mu_a = DUMMY_VAR__;
      
      current_statement__ = 4;
      mu_a = in__.scalar();
      local_scalar_t__ mu_b;
      mu_b = DUMMY_VAR__;
      
      current_statement__ = 5;
      mu_b = in__.scalar();
      local_scalar_t__ mu_s;
      mu_s = DUMMY_VAR__;
      
      current_statement__ = 6;
      mu_s = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        mu_s = stan::math::lb_constrain(mu_s, 0, lp__);
      } else {
        current_statement__ = 6;
        mu_s = stan::math::lb_constrain(mu_s, 0);
      }
      local_scalar_t__ sigma_a;
      sigma_a = DUMMY_VAR__;
      
      current_statement__ = 7;
      sigma_a = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        sigma_a = stan::math::lb_constrain(sigma_a, 0, lp__);
      } else {
        current_statement__ = 7;
        sigma_a = stan::math::lb_constrain(sigma_a, 0);
      }
      local_scalar_t__ sigma_b;
      sigma_b = DUMMY_VAR__;
      
      current_statement__ = 8;
      sigma_b = in__.scalar();
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        sigma_b = stan::math::lb_constrain(sigma_b, 0, lp__);
      } else {
        current_statement__ = 8;
        sigma_b = stan::math::lb_constrain(sigma_b, 0);
      }
      local_scalar_t__ sigma_s;
      sigma_s = DUMMY_VAR__;
      
      current_statement__ = 9;
      sigma_s = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        sigma_s = stan::math::lb_constrain(sigma_s, 0, lp__);
      } else {
        current_statement__ = 9;
        sigma_s = stan::math::lb_constrain(sigma_s, 0);
      }
      {
        int id;
        id = std::numeric_limits<int>::min();
        
        current_statement__ = 10;
        id = 1;
        current_statement__ = 22;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 20;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_a, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 19;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 17;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_a, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 16;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 14;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_a, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 13;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 11;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_a, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 23;
        id = 2;
        current_statement__ = 35;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 33;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_a, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 32;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 30;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_a, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 29;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 27;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_a, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 26;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 24;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_a,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 36;
        id = 3;
        current_statement__ = 48;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 46;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_b, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 45;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 43;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_b, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 42;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 40;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_b, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 39;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 37;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_b, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 49;
        id = 4;
        current_statement__ = 61;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 59;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_b, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 58;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 56;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_b, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 55;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 53;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_b, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 52;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 50;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_b,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 62;
        id = 5;
        current_statement__ = 74;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 72;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 71;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 69;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 68;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 66;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 65;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 63;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 75;
        id = 6;
        current_statement__ = 87;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 85;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 84;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 82;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 81;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 79;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 78;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 76;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_s,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 88;
        lp_accum__.add(normal_lpdf<propto__>(alpha, mu_a, sigma_a));
        current_statement__ = 89;
        lp_accum__.add(normal_lpdf<propto__>(beta, mu_b, sigma_b));
        current_statement__ = 90;
        lp_accum__.add(normal_lpdf<propto__>(sigma, mu_s, sigma_s));
        current_statement__ = 92;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 91;
          lp_accum__.add(
            normal_lpdf<propto__>(y[(i - 1)],
              (alpha[(s[(i - 1)] - 1)] +
                (beta[(s[(i - 1)] - 1)] * x[(i - 1)])),
              sigma[(s[(i - 1)] - 1)]));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_linear_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      alpha = in__.vector(m);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta = in__.vector(m);
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      sigma = in__.vector(m);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      double mu_a;
      mu_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu_a = in__.scalar();
      double mu_b;
      mu_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_b = in__.scalar();
      double mu_s;
      mu_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s = in__.scalar();
      current_statement__ = 6;
      mu_s = stan::math::lb_constrain(mu_s, 0);
      double sigma_a;
      sigma_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_a = in__.scalar();
      current_statement__ = 7;
      sigma_a = stan::math::lb_constrain(sigma_a, 0);
      double sigma_b;
      sigma_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_b = in__.scalar();
      current_statement__ = 8;
      sigma_b = stan::math::lb_constrain(sigma_b, 0);
      double sigma_s;
      sigma_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s = in__.scalar();
      current_statement__ = 9;
      sigma_s = stan::math::lb_constrain(sigma_s, 0);
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      vars__.emplace_back(mu_a);
      vars__.emplace_back(mu_b);
      vars__.emplace_back(mu_s);
      vars__.emplace_back(sigma_a);
      vars__.emplace_back(sigma_b);
      vars__.emplace_back(sigma_s);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 1;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 1;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 2;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_flat__;
        current_statement__ = 3;
        assign(sigma_flat__, nil_index_list(), context__.vals_r("sigma"),
          "assigning variable sigma_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 3;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_flat__[(pos__ - 1)], "assigning variable sigma");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_free__;
      sigma_free__ = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      double mu_a;
      mu_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu_a = context__.vals_r("mu_a")[(1 - 1)];
      double mu_b;
      mu_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_b = context__.vals_r("mu_b")[(1 - 1)];
      double mu_s;
      mu_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s = context__.vals_r("mu_s")[(1 - 1)];
      double mu_s_free__;
      mu_s_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s_free__ = stan::math::lb_free(mu_s, 0);
      double sigma_a;
      sigma_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_a = context__.vals_r("sigma_a")[(1 - 1)];
      double sigma_a_free__;
      sigma_a_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_a_free__ = stan::math::lb_free(sigma_a, 0);
      double sigma_b;
      sigma_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_b = context__.vals_r("sigma_b")[(1 - 1)];
      double sigma_b_free__;
      sigma_b_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_b_free__ = stan::math::lb_free(sigma_b, 0);
      double sigma_s;
      sigma_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s = context__.vals_r("sigma_s")[(1 - 1)];
      double sigma_s_free__;
      sigma_s_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s_free__ = stan::math::lb_free(sigma_s, 0);
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
      vars__.emplace_back(mu_a);
      vars__.emplace_back(mu_b);
      vars__.emplace_back(mu_s_free__);
      vars__.emplace_back(sigma_a_free__);
      vars__.emplace_back(sigma_b_free__);
      vars__.emplace_back(sigma_s_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha");
    names__.emplace_back("beta");
    names__.emplace_back("sigma");
    names__.emplace_back("mu_a");
    names__.emplace_back("mu_b");
    names__.emplace_back("mu_s");
    names__.emplace_back("sigma_a");
    names__.emplace_back("sigma_b");
    names__.emplace_back("sigma_s");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_a");
    param_names__.emplace_back(std::string() + "mu_b");
    param_names__.emplace_back(std::string() + "mu_s");
    param_names__.emplace_back(std::string() + "sigma_a");
    param_names__.emplace_back(std::string() + "sigma_b");
    param_names__.emplace_back(std::string() + "sigma_s");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_a");
    param_names__.emplace_back(std::string() + "mu_b");
    param_names__.emplace_back(std::string() + "mu_s");
    param_names__.emplace_back(std::string() + "sigma_a");
    param_names__.emplace_back(std::string() + "sigma_b");
    param_names__.emplace_back(std::string() + "sigma_s");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"mu_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"mu_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_linear_namespace::model_linear;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_linear_namespace::profiles__;
}
#endif
#endif
