% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reaction_time_class.R
\docType{class}
\name{reaction_time_class-class}
\alias{reaction_time_class-class}
\alias{reaction_time_class}
\title{reaction_time_class}
\description{
An S4 class for storing results of reaction time Bayesian model.

\strong{Functions}

summary(`reaction_time_class`): prints a summary of the fit.

print(`reaction_time_class`): prints a more detailed summary of the fit

show(`reaction_time_class`): prints a more detailed summary of the fit.

plot(`reaction_time_class`): plots fitted model against the data. Use this function to explore the quality of your fit.

plot(`reaction_time_class`, subjects='boolean'): plots fitted model against the data. Use this function to explore the quality of your fit. You can plot on the subject level (subjects=TRUE) or on the group level (subjects=FALSE).

plot_fit(`reaction_time_class`): plots fitted model against the data. Use this function to explore the quality of your fit.

plot_fit(`reaction_time_class`, subjects='boolean'): plots fitted model against the data. Use this function to explore the quality of your fit. You can plot on the subject level (subjects=TRUE) or on the group level (subjects=FALSE).

plot_trace(`reaction_time_class`): traceplot for main fitted model parameters.

get_parameters(`reaction_time_class`): returns a dataframe with values of fitted parameters.

get_subject_parameters(`reaction_time_class`): returns a dataframe with values of fitted parameters for each subject in the hierarchical model.

compare_means(`reaction_time_class`, fit2=`reaction_time_class`): returns difference in reaction times between two groups. You can also provide the rope parameter or execute the comparison only through a chosen parameter - mu or lambda.

compare_means(`reaction_time_class`, fits=`list`): returns difference in reaction times between multiple groups. You can also provide the rope parameter. You can also provide the rope parameter or execute the comparison only through a chosen parameter - mu or lambda.

plot_means_difference(`reaction_time_class`, fit2=`reaction_time_class`): a visualization of the difference between two groups. You can also provide the rope and bins (number of bins in the histogram) parameters or visualize the comparison only through a chosen parameter - mu or lambda.

plot_means_difference(`reaction_time_class`, fits=`list`): a visualization of the difference between multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters or visualize the comparison only through a chosen parameter - mu or lambda.

plot_means(`reaction_time_class`): plots density of the means. You can also visualize the density only for a chosen parameter - mu or lambda.

plot_means(`reaction_time_class`, fit2=`reaction_time_class`): plots density for the first and the second group means. You can also visualize the density only for a chosen parameter - mu or lambda.

plot_means(`reaction_time_class`, fits=`list`): plots density for means of multiple groups. You can also visualize the density only for a chosen parameter - mu or lambda.

compare_distributions(`reaction_time_class`, fit2=`reaction_time_class`): draws samples from distribution of the first group and compares them against samples drawn from the distribution of the second group. You can also provide the rope parameter.

compare_distributions(`reaction_time_class`, fits=`lists`): draws and compares samples from distributions of multiple groups. You can also provide the rope parameter.

plot_distributions(`reaction_time_class`): a visualization of the fitted distribution.

plot_distributions(`reaction_time_class`, fit2=`reaction_time_class`): a visualization of the distribution for two fits.

plot_distributions(`reaction_time_class`, fits=`list`): a visualization of the distribution for multiple fits.

plot_distributions_difference(`reaction_time_class`, fit2=`reaction_time_class`): a visualization of the difference between the distribution of the first group and the second group. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_distributions_difference(`reaction_time_class`, fits=`list`): a visualization of the difference between the distributions of multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters.
}
\section{Slots}{

\describe{
\item{\code{extract}}{Extract from Stan fit.}

\item{\code{fit}}{Stan fit.}

\item{\code{data}}{Data on which the fit is based.}
}}

\examples{
\donttest{
# priors
mu_prior <- b_prior(family="normal", pars=c(0, 100))
sigma_prior <- b_prior(family="uniform", pars=c(0, 500))
lambda_prior <- b_prior(family="uniform", pars=c(0.05, 5))

# attach priors to relevant parameters
priors <- list(c("mu_m", mu_prior),
               c("sigma_m", sigma_prior),
               c("mu_s", sigma_prior),
               c("sigma_s", sigma_prior),
               c("mu_l", lambda_prior),
               c("sigma_l", sigma_prior))


# subjects
s <- rep(1:5, 20)

# generate data and fit
rt1 <- emg::remg(100, mu=10, sigma=1, lambda=0.4)
fit1 <- b_reaction_time(t=rt1, s=s, priors=priors, chains=1)

rt2 <- emg::remg(100, mu=10, sigma=2, lambda=0.1)
fit2 <- b_reaction_time(t=rt2, s=s, priors=priors, chains=1)

rt3 <- emg::remg(100, mu=20, sigma=2, lambda=1)
fit3 <- b_reaction_time(t=rt3, s=s, priors=priors, chains=1)

rt4 <- emg::remg(100, mu=15, sigma=2, lambda=0.5)
fit4 <- b_reaction_time(t=rt4, s=s, priors=priors, chains=1)

# fit list
fit_list <- list(fit2, fit3, fit4)

# a short summary of fitted parameters
summary(fit1)

# a more detailed summary of fitted parameters
print(fit1)
show(fit1)

# plot the fitted distribution against the data
plot(fit1)
plot_fit(fit1)

# plot the fitted distribution against the data,
# plot on the top (group) level
plot(fit1, subjects=FALSE)
plot_fit(fit1, subjects=FALSE)

# traceplot of the fitted parameters
plot_trace(fit1)

# extract parameter values from the fit
parameters <- get_parameters(fit1)

# extract parameter values on the bottom (subject) level from the fit
subject_parameters <- get_subject_parameters(fit1)

# compare means between two fits, use a rope interval
compare_means(fit1, fit2=fit2, rope=0.5)

# compare means between two fits,
# use only the mu parameter of the exponentially modified gaussian distribution
compare_means(fit1, fit2=fit2, par="mu")

# compare means between multiple fits
compare_means(fit1, fits=fit_list)

# visualize difference in means between two fits,
# specify number of histogram bins and rope interval
plot_means_difference(fit1, fit2=fit2, bins=20, rope=0.5)

# visualize difference in means between two fits,
# use only the mu parameter of the exponentially modified gaussian distribution
plot_means_difference(fit1, fit2=fit2, par="mu")

# visualize difference in means between multiple fits
plot_means_difference(fit1, fits=fit_list)

# visualize means of a single fit
plot_means(fit1)

# visualize means of two fits
plot_means(fit1, fit2=fit1)

# visualize means of two fits,
# use only the mu parameter of the exponentially modified gaussian distribution
plot_means(fit1, fit2=fit2, par="mu")

# visualize means of multiple fits
plot_means(fit1, fits=fit_list)

# draw samples from distributions underlying two fits and compare them,
# use a rope interval
compare_distributions(fit1, fit2=fit2, rope=0.5)

# draw samples from distributions underlying multiple fits and compare them
compare_distributions(fit1, fits=fit_list)

# visualize the distribution underlying a fit
plot_distributions(fit1)

# visualize distributions underlying two fits
plot_distributions(fit1, fit2=fit2)

# visualize distributions underlying multiple fits
plot_distributions(fit1, fits=fit_list)

# visualize difference between distributions underlying two fits,
# use a rope interval
plot_distributions_difference(fit1, fit2=fit2, rope=0.05)

# visualize difference between distributions underlying multiple fits
plot_distributions_difference(fit1, fits=fit_list)
}

}
