% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDists.R
\docType{data}
\name{plotDistributions}
\alias{plotDistributions}
\title{Plot distributions to explore data and/or choose priors.}
\description{
These are helper functions to help explore data and/or choose priors. Click further for more details.

\itemize{
\item \link{plotBeta}
\item \link{plotGamma}
\item \link{plotInvGamma}
\item \link{plotLogNormal}
\item \link{plotNormal}
\item \link{plotPareto}
\item \link{plotPoisson}
}
}
\note{
Choosing priors correctly is very important. Please see http://fportman.com/blog/bayesab-0-dot-7-0-plus-a-primer-on-priors/ for a detailed example of choosing priors
within bayesAB. Here are some ways to leverage objective/diffuse (assigning equal probability to all values) priors:

\itemize{\item \code{Beta}(1, 1)
         \item \code{Gamma}(eps, eps) ~ \code{Gamma}(.00005, .00005) will be effectively diffuse
         \item \code{InvGamma}(eps, eps) ~ \code{InvGamma}(.00005, .00005) will be effectively diffuse
         \item \code{Pareto}(eps, eps) ~ \code{Pareto}(.005, .005) will be effectively diffuse}

Keep in mind that the Prior Plots for bayesTest's run with diffuse priors may not plot correctly as they will not be truncated as they
approach infinity. See \link{plot.bayesTest} for how to turn off the Prior Plots.

plot{...} functions are generated programmatically so the function calls in
their \code{body} will be substituted directly
}
