% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPotts.R
\name{gibbsPotts}
\alias{gibbsPotts}
\title{Fit a hidden Potts model to the observed data, using a fixed value of beta.}
\usage{
gibbsPotts(y, labels, beta, mu, sd, neighbors, blocks, priors, niter = 1)
}
\arguments{
\item{y}{A vector of observed pixel data.}

\item{labels}{A matrix of pixel labels.}

\item{beta}{The inverse temperature parameter of the Potts model.}

\item{mu}{A vector of means for the mixture components.}

\item{sd}{A vector of standard deviations for the mixture components.}

\item{neighbors}{A matrix of all neighbors in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{priors}{A list of priors for the parameters of the model.}

\item{niter}{The number of iterations of the algorithm to perform.}
}
\value{
A matrix containing MCMC samples for the parameters of the Potts model.
}
\description{
Fit a hidden Potts model to the observed data, using a fixed value of beta.
}
