% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_regimes.R
\name{find_regimes}
\alias{find_regimes}
\title{Fit multiple models with differing numbers of regimes to trend data}
\usage{
find_regimes(y, sds = NULL, min_regimes = 1, max_regimes = 3,
  iter = 2000, thin = 1, chains = 1, ...)
}
\arguments{
\item{y}{Data, time series or trend from fitted DFA model.}

\item{sds}{Optional time series of standard deviations of estimates. If
passed in, residual variance not estimated.}

\item{min_regimes}{Smallest of regimes to evaluate, defaults to 1.}

\item{max_regimes}{Biggest of regimes to evaluate, defaults to 3.}

\item{iter}{MCMC iterations, defaults to 2000.}

\item{thin}{MCMC thinning rate, defaults to 1.}

\item{chains}{MCMC chains; defaults to 1 (note that running multiple chains
may result in a "label switching" problem where the regimes are identified
with different IDs across chains).}

\item{...}{Other parameters to pass to \code{\link[rstan:sampling]{rstan::sampling()}}.}
}
\description{
Fit multiple models with differing numbers of regimes to trend data
}
\examples{
data(Nile)
find_regimes(log(Nile), iter = 500, chains = 1, max_regimes = 2)
}
