% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_cv.R
\name{dfa_cv}
\alias{dfa_cv}
\title{Apply cross validation to DFA model}
\usage{
dfa_cv(
  stanfit,
  cv_method = c("loocv", "lfocv"),
  fold_ids = NULL,
  n_folds = 10,
  iter = 2000,
  chains = 4,
  thin = 1,
  ...
)
}
\arguments{
\item{stanfit}{A stanfit object, to preserve the model structure from a call to fit_dfa()}

\item{cv_method}{The method used for cross validation. The options are 'loocv', where time is ignored and each data point is
assigned randomly to a fold. The method 'ltocv' is leave time out cross validation, and time slices are iteratively held out
out. Finally the method 'lfocv' implements leave future out cross validation to do one-step ahead predictions.}

\item{fold_ids}{A vector whose length is the same as the number of total data points. Elements are the fold id of each data point. If not all data points are
used (e.g. the lfocv or ltocv approach might only use 10 time steps) the value can be something other than a numbber,
e.g. NA}

\item{n_folds}{Number of folds, defaults to 10}

\item{iter}{Number of iterations in Stan sampling, defaults to 2000.}

\item{chains}{Number of chains in Stan sampling, defaults to 4.}

\item{thin}{Thinning rate in Stan sampling, defaults to 1.}

\item{...}{Any other arguments to pass to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\description{
Apply cross validation to DFA model
}
\examples{
\dontrun{
set.seed(42)
s <- sim_dfa(num_trends = 1, num_years = 20, num_ts = 3)
obs <- c(s$y_sim[1, ], s$y_sim[2, ], s$y_sim[3, ])
long <- data.frame("obs" = obs, "ts" = sort(rep(1:3, 20)),
"time" = rep(1:20, 3))
m <- fit_dfa(y = long, iter = 50, chains = 1, data_shape = "long",
sample = FALSE)
# random folds
fit_cv <- dfa_cv(m, cv_method = "loocv", n_folds = 5, iter = 50, chains = 1)

# folds can also be passed in
fold_ids <- sample(1:5, size = nrow(long), replace = TRUE)
m <- fit_dfa(y = long, iter = 50, chains = 1, data_shape = "long",
sample = FALSE)
fit_cv <- dfa_cv(m, cv_method = "loocv", n_folds = 5, iter = 50, chains = 1,
fold_ids = fold_ids)

# do an example of leave-time-out cross validation where years are dropped
fold_ids <- long$time
m <- fit_dfa(y = long, iter = 50, chains = 1, data_shape = "long",
sample = FALSE)
fit_cv <- dfa_cv(m, cv_method = "loocv", iter = 100, chains = 1,
fold_ids = fold_ids)

# example with covariates and long format data
obs_covar <- expand.grid("time" = 1:20, "timeseries" = 1:3,
"covariate" = 1:2)
obs_covar$value <- rnorm(nrow(obs_covar), 0, 0.1)
obs <- c(s$y_sim[1, ], s$y_sim[2, ], s$y_sim[3, ])
m <- fit_dfa(y = long, iter = 50, chains = 1, obs_covar = obs_covar,
data_shape = "long", sample = FALSE)
fit_cv <- dfa_cv(m, cv_method = "loocv", n_folds = 5, iter = 50, chains = 1)
}

}
