% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.varstan}
\alias{posterior_predict.varstan}
\alias{posterior_predict}
\title{Draw from posterior predictive h steps ahead distribution}
\usage{
\method{posterior_predict}{varstan}(
  object,
  h = 0,
  xreg = NULL,
  robust = FALSE,
  draws = 1000,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{a varstan object}

\item{h}{An integer indicating the number of predictions. The default number
of predictions is 12.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{robust}{A boolean for obtain the robust estimation. The default}

\item{draws}{An integer indicating the number of draws to return. The default
number of draws is 1000}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{...}{Further arguments passed to  \code{posterior_predict}.}
}
\value{
A \code{draws} by \code{h} data.frame of simulations from the
posterior predictive distribution. Each row of the data.frame
is a vector of predictions generated using a single draw of
the model parameters from the posterior distribution.
}
\description{
The posterior predictive distribution is the distribution of the outcome
implied by the model after using the observed data to update our beliefs
about the unknown parameters in the model. Simulating data from the posterior
predictive distribution using the observed predictors is useful for checking
the fit of the model. Drawing from the posterior predictive distribution at
interesting values of the predictors also lets us visualize how a
manipulation of a predictor affects (a function of) the outcome(s). With new
observations of predictor variables we can use the posterior predictive
distribution to generate predicted outcomes.
}
\author{
Asael Alonzo Matamoros
}
