% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_factor.R
\name{bayes_factor.varstan}
\alias{bayes_factor.varstan}
\alias{bayes_factor}
\title{Bayes Factors from Marginal Likelihoods.}
\usage{
\method{bayes_factor}{varstan}(x1, x2, log = FALSE, ...)
}
\arguments{
\item{x1}{A \code{varstan} object}

\item{x2}{Another \code{varstan} object based on the same data.}

\item{log}{A boolean parameter for report the Bayes_factor in log scale.
The default value is FALSE.}

\item{...}{Additional arguments passed to \code{bayes_factor}.}
}
\value{
The bayes factors of two models.
}
\description{
Compute Bayes factors from marginal likelihoods.
}
\details{
The computation of marginal likelihoods based on bridge sampling requires
a lot more posterior samples than usual. A good conservative rule of thump
is perhaps 10-fold more samples (read: the default of 4000 samples may not
be enough in many cases). If not enough posterior samples are provided, the
bridge sampling algorithm tends to be unstable leading to considerably different
results each time it is run. We thus recommend running \code{bridge_sampler}
multiple times to check the stability of the results.

For  more details check the \pkg{bridgesampling} package.
}
\examples{
\donttest{
 library(astsa)
 # Fitting a seasonal arima model
 mod1 = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(mod1,iter = 500,chains = 1)

 # Fitting a Dynamic harmonic regression
 mod2  = Sarima(birth,order = c(0,1,2),xreg = fourier(birth,K=6))
 fit2 = varstan(mod2,iter = 500,chains = 1)

 # compute the Bayes factor
 bayes_factor(fit1, fit2)
}

}
