% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{gghist}
\alias{gghist}
\title{Histogram with optional normal density functions}
\usage{
gghist(y, title = NULL, xlab = NULL, ylab = "counts", bins, add.normal = TRUE)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{title}{a string with the plot's title.}

\item{xlab}{a string with the plot's x axis label. By default a NUll value}

\item{ylab}{a string with the plot's y axis label. By default a "counts" value}

\item{bins}{The number of bins to use for the histogram. Selected by default
using the Friedman-Diaconis rule.}

\item{add.normal}{A boolean value. Add a normal density function for comparison,
by default \code{add.normal = TRUE}.}
}
\value{
None. Function produces a ggplot2 graph.
}
\description{
Plots a histogram and density estimates using ggplot.
}
\examples{
x = rnorm(100)
gghist(x,add.normal = TRUE)

}
\author{
Rob J Hyndman
}
