% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-naive_reg.R
\name{random_walk_reg}
\alias{random_walk_reg}
\title{General Interface for Naive and Random Walk models Regression Models}
\usage{
random_walk_reg(
  mode = "regression",
  seasonal_random_walk = NULL,
  seasonal_period = NULL,
  markov_chains = NULL,
  chain_iter = NULL,
  warmup_iter = NULL,
  adapt_delta = NULL,
  tree_depth = NULL,
  pred_seed = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{seasonal_random_walk}{a Boolean value for select a seasonal random walk instead.}

\item{seasonal_period}{an optional integer value for the seasonal period.}

\item{markov_chains}{An integer of the number of Markov Chains chains to be run, by default 4 chains are run.}

\item{chain_iter}{An integer of total iterations per chain including the warm-up, by default the number of iterations are 2000.}

\item{warmup_iter}{A positive integer specifying number of warm-up (aka burn-in) iterations. This also specifies the number of iterations used for step-size adaptation, so warm-up samples should not be used for inference. The number of warmup should not be larger than iter and the default is iter/2.}

\item{adapt_delta}{An optional real value between 0 and 1, the thin of the jumps in a HMC method. By default is 0.9}

\item{tree_depth}{An integer of the maximum depth of the trees evaluated during each iteration. By default is 10.}

\item{pred_seed}{An integer with the seed for using when predicting with the model.}
}
\value{
A model spec
}
\description{
\code{random_walk_reg()} is a way to generate a \emph{specification} of Naive and Random Walk models
before fitting and allows the model to be created using
different packages. Currently the only package is \code{bayesforecast}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{random_walk_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "stan" (default) - Connects to \code{\link[bayesforecast:stan_naive]{bayesforecast::stan_naive()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are:
\itemize{
\item \code{seasonal_random_walk}: a Boolean value for select a seasonal random walk instead.
\item \code{markov_chains}: An integer of the number of Markov Chains chains to be run.
\item \code{adapt_delta}: The thin of the jumps in a HMC method.
\item \code{tree_depth}: The maximum depth of the trees evaluated during each iteration.
}

These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\section{Engine Details}{


The standardized parameter names in \code{bayesmodels} can be mapped to their original
names in each engine:\tabular{ll}{
   bayesmodels \tab bayesforecast::stan_naive \cr
   seasonal_random_walk \tab seasonal \cr
   markov_chains \tab chains(4) \cr
   adapt_delta \tab adapt.delta(0.9) \cr
   tree_depth \tab tree.depth(10) \cr
}


Other options can be set using \code{set_engine()}.

\strong{stam (default engine)}

The engine uses \code{\link[bayesforecast:stan_naive]{bayesforecast::stan_naive()}}.
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\emph{Seasonal Period Specification}

The period can be non-seasonal (\verb{seasonal_period = 1 or "none"}) or
yearly seasonal (e.g. For monthly time stamps, \code{seasonal_period = 12}, \code{seasonal_period = "12 months"}, or \code{seasonal_period = "yearly"}).
There are 3 ways to specify:
\enumerate{
\item \code{seasonal_period = "auto"}: A seasonal period is selected based on the periodicity of the data (e.g. 12 if monthly)
\item \code{seasonal_period = 12}: A numeric frequency. For example, 12 is common for monthly data
\item \code{seasonal_period = "1 year"}: A time-based phrase. For example, "1 year" would convert to 12 for monthly data.
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
}
}

\examples{
\dontrun{
#The example works, just building problem
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(bayesmodels)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- rsample::initial_time_split(m750, prop = 0.8)


# Model Spec
model_spec <- random_walk_reg() \%>\%
    set_engine("stan")

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit
}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
