% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-adaptive_splines_params.R
\name{adaptive_splines_params}
\alias{adaptive_splines_params}
\alias{splines_degree}
\alias{max_degree}
\alias{max_categorical_degree}
\alias{min_basis_points}
\title{Tuning Parameters for Adaptive Splines Surface Models}
\usage{
splines_degree(range = c(0L, 5L), trans = NULL)

max_degree(range = c(0L, 5L), trans = NULL)

max_categorical_degree(range = c(0L, 5L), trans = NULL)

min_basis_points(range = c(0L, 1000L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A parameter

A parameter

A parameter

A parameter
}
\description{
Tuning Parameters for Adaptive Splines Surface Models
}
\details{
The main parameters for Adaptive Splines Surface models are:
\itemize{
\item \code{splines_degree}: degree of splines. Stability should be examined for anything other than 1.
\item \code{max_degree}: integer for maximum degree of interaction in spline basis functions.
\item \code{max_categorical_degree}: (categorical input only) integer for maximum degree of interaction of categorical inputs.
\item \code{min_basis_points}: minimum number of non-zero points in a basis function
}
}
\examples{
splines_degree()

max_degree()

min_basis_points()


}
