% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{likelihood}
\alias{likelihood}
\title{Specify a likelihood}
\usage{
likelihood(family, ...)
}
\arguments{
\item{family}{the likelihood distribution (see details)}

\item{...}{see details}
}
\value{
an object of class \code{likelihood}
}
\description{
Define likelihoods using different different distribution families #nolint
}
\details{
\subsection{Available distribution families}{

The following distribution families can be used for the likelihood
\itemize{
\item \code{normal} a normal distribution
\item \code{student_t} a scaled and shifted t-distribution
\item \code{noncentral_t} a noncentral t (for t statistic)
\item \code{noncentral_d} a noncentral t (for one sample d)
\item \code{noncentral_d2} a noncentral t (for independent samples d)
\item \code{binomial} a binomial distribution
The parameters that need to be specified will be dependent on the
family
}
}

\subsection{normal distribution}{

When \code{family} is set to \code{normal} then the following
parameters must be set
\itemize{
\item \code{mean} mean of the normal likelihood
\item \code{sd} standard deviation of the normal likelihood
}
}

\subsection{student_t distribution}{

When \code{family} is set to \code{student_t} then the following
parameters may be set
\itemize{
\item \code{mean} mean of the scaled and shifted t likelihood
\item \code{sd} standard deviation of the scaled and shifted t likelihood
\item \code{df} degrees of freedom
}
}

\subsection{noncentral_t distribution}{

When \code{family} is set to \code{noncentral_t} then the following
parameters may be set
\itemize{
\item \code{t} the t value of the data
\item \code{df} degrees of freedom
}
}

\subsection{noncentral_d distribution}{

When \code{family} is set to \code{noncentral_d} then the following
parameters may be set
\itemize{
\item \code{d} the d (mean / sd) value of the data
\item \code{n} the sample size
}
}

\subsection{noncentral_d2 distribution}{

When \code{family} is set to \code{noncentral_d2} then the following
parameters may be set
\itemize{
\item \code{d} the d (mean / s_pooled) value of the data
\item \code{n1} the sample size of group 1
\item \code{n2} the sample size of group 2
}

\eqn{s_{\mathrm{pooled}}}{s_pooled} is set as below:
\deqn{s_{\mathrm{pooled}} = \sqrt{\frac{(n_1 - 1)s^2_1 + (n_2 - 1)s^2_2 }{n_1 + n_2 - 2}}}{\sqrt(((n1 - 1) * s1^2 + (n2 - 1)*s2^2)/(n1 + n2 - 2))}
}

\subsection{binomial distribution}{

When the \code{family} is set to \code{binomial} then the following
parameters may be set
\itemize{
\item \code{successes} the number of successes
\item \code{trials} the number of trials
}
}
}
\examples{
# specify a normal likelihood
likelihood(family = "normal", mean = 5.5, sd = 32.35)

# specify a scaled and shifted t likelihood
likelihood(family = "student_t", mean = 5.5, sd = 32.35, df = 10)

# specify non-central t likelihood (t scaled)
likelihood(family = "noncentral_t", t = 10, df = 10)

# specify non-central t likelihood (d scaled)
likelihood(family = "noncentral_d", d = 10, n = 10)

# specify non-central t likelihood (independent samples d scaled)
likelihood(family = "noncentral_d2", d = 10, n1 = 10, n2 = 12)

# specify a binomial likelihood
likelihood(family = "binomial", successes = 2, trials = 10)
}
